#!/bin/sh

. ./_blfsset.sh

APPNAME=openldap
VER=2.4.46
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openslp tcp_wrappers icu \
	unixODBC db cyrus-sasl
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

#mkdir -p /var/lib/openldap

groupadd -g 83 ldap
useradd  -c "OpenLDAP Daemon Owner" \
         -d /var/lib/openldap -u 83 \
         -g ldap -s /bin/false ldap

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/openldap-$VER-consolidated-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
autoconf \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr         \
            --sysconfdir=/etc     \
            --localstatedir=/var  \
            --libexecdir=/usr/lib \
            --disable-static      \
            --disable-debug       \
            --with-tls=openssl    \
$([ ${OPTION_cyrussasl} -eq 1 ] && echo --with-cyrus-sasl) \
$([ ${OPTION_cyrussasl} -ne 1 ] && echo --without-cyrus-sasl) \
            --enable-dynamic      \
            --enable-crypt        \
$([ ${OPTION_cyrussasl} -eq 1 ] && echo --enable-spasswd) \
            --enable-slapd        \
$([ ${OPTION_openslp} -eq 1 ] && echo --enable-slpd) \
            --enable-modules      \
            --enable-rlookups     \
            --enable-backends=mod \
            --disable-ndb         \
            --disable-sql         \
            --disable-shell       \
            --disable-bdb         \
            --disable-hdb         \
            --enable-overlays=mod \
$([ ${OPTION_tcp_wrappers} -eq 1 ] && echo --enable-wrappers) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo Making depend...
make depend \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Making
make \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -dm700 -o ldap -g ldap /var/lib/openldap" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -dm700 -o ldap -g ldap /etc/openldap/slapd.d" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod   -v    640     /etc/openldap/slapd.{conf,ldif}
chown   -v  root:ldap /etc/openldap/slapd.{conf,ldif}

install -dm 755 /usr/share/doc/openldap-$VER

porg -lp+ $TARGET "\
cp      -vfr      doc/{drafts,rfc,guide} \
                  /usr/share/doc/openldap-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

