#!/bin/sh

. ./_blfsset.sh

APPNAME=lmdb
VER=0.9.24
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/LMDB_$VER.tar.gz
TARGETDIR=$APPNAME-LMDB_$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cd libraries/liblmdb

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

sed -i 's| liblmdb.a||' Makefile
Installing
porg -lp $TARGET "make prefix=/usr install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../../..
RemoveSrcDir
PorgingDone

