#!/bin/sh

. ./_blfsset.sh

APPNAME=libxslt
VER=1.1.34
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh libxml2
. $WRK/_checkOptions.sh  python-2 libgcrypt
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $DLD/libxslt-$VER-security_fix-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i s/3000/5000/ libxslt/transform.c doc/xsltproc.{1,xml}

Configuring
./configure --prefix=/usr --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET -E`pwd` "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

