#!/bin/sh

. ./_blfsset.sh

APPNAME=ghostscript
VER=9.26
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	freetype libjpeg-turbo libpng libtiff lcms2
. $WRK/_checkOptions.sh  \
	cairo cups fontconfig gtk+-3 libidn \
	libpaper
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

rm -rf freetype jpeg lcms2 libpng

echo Patching...
patch -Np1 -i $DLD/ghostscript-$VER-upstream_fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure \
	--prefix=/usr \
	--enable-dynamic \
	--with-system-libtiff \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo Making so...
make so \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Installing so...
porg -lp+ $TARGET -E`pwd` "make soinstall" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 base/*.h /usr/include/ghostscript" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -sfvn ghostscript /usr/include/ps" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -sfvn ../ghostscript/$VER/doc /usr/share/doc/ghostscript-$VER && \
cp -a examples/ /usr/share/ghostscript/$VER/ \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
tar -xvf $DLD/ghostscript-fonts-std-8.11.tar.gz \
  -C /usr/share/ghostscript --no-same-owner"

porg -lp+ $TARGET "\
tar -xvf $DLD/gnu-gs-fonts-other-6.0.tar.gz \
  -C /usr/share/ghostscript --no-same-owner

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

fc-cache -v /usr/share/ghostscript/fonts/

cd ..
RemoveSrcDir
PorgingDone
