#!/bin/sh

. ./_blfsset.sh

APPNAME=docker-ce
VER=19.03.11
TARGET=$APPNAME-$VER
TARGETBALL1=$DLD/docker/$TARGET/docker-$VER.tgz
TARGETBALL2=$DLD/docker/$TARGET/docker-rootless-extras-$VER.tgz
TARGETDIR1=docker
TARGETDIR2=docker-rootless-extras

echo $TARGET

. $WRK/_checkRequired.sh \
	iptables
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract ${TARGETBALL1}
Extract ${TARGETBALL2}

TimeStart

cd ${TARGETDIR1}

Installing
porg -lp $TARGET "\
cp -p * /usr/bin" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cd ../${TARGETDIR2}
porg -lp+ $TARGET "\
cp -p * /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -m 644 $DLD/docker.service /lib/systemd/system" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -m 644 $DLD/docker.socket /lib/systemd/system" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

