#!/bin/sh

VER=0.14.0
TARGET=xf86-input-wacom-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

. ../_blfsset.sh
. ./_xorgset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Configuring... 
./configure $XORG_CONFIG \
            --with-xorg-module-dir=$XORG_PREFIX/lib/X11/modules \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

