//
//  KMHTMLBuilder.m
//  DocumentTest
//
//  Created by 堀 昌樹 on 11/12/11.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMHTMLBuilder.h"
#import "CMRThreadMessage.h"


@implementation KMHTMLBuilder

- (NSString *)templateByName:(NSString *)name
{
	NSBundle *mainBundle = [NSBundle mainBundle];	
	NSError *error = nil;
	NSString *html = [NSString stringWithContentsOfURL:[mainBundle URLForResource:name withExtension:@"html"]
											  encoding:NSASCIIStringEncoding
												 error:&error];
	if(!html) {
		if(error) {
			NSLog(@"%@", error);
		}
		return nil;
	}
	return html;
}

- (id)result
{
	NSString *htmlTemplate = [self templateByName:@"HTML"];
	NSString *headTemplate = [self templateByName:@"head"];
	NSString *bodyTemplate = [self templateByName:@"body"];
	NSString *responsTemplate = [self templateByName:@"response"];
	
	
	// HEAD
	NSString *threadTitle = self.document.threadTitle ?: @"";
	NSString *head = [headTemplate stringByReplacingOccurrencesOfString:@"@@TITLE@@" withString:threadTitle];
	NSBundle *mainBundle = [NSBundle mainBundle];
	NSString *cssPath = [mainBundle pathForResource:@"basic" ofType:@"css"];
	NSURL *cssURL = [NSURL fileURLWithPath:cssPath];
	head = [head stringByReplacingOccurrencesOfString:@"@@CSS_FILE_URL@@" withString:[cssURL absoluteString]];
	
	// contents
	NSMutableArray *responses = [NSMutableArray arrayWithCapacity:[self.document numberOfReadedMessages]];
	NSUInteger index = 1;
	for(CMRThreadMessage *message in self.document.messages) {
		NSString *response = [responsTemplate stringByReplacingOccurrencesOfString:@"@@NUMBER@@" 
																		withString:[NSString stringWithFormat:@"%d", index++]];
		response = [response stringByReplacingOccurrencesOfString:@"@@NAME_CAPTION@@"
													   withString:@"Name:"];
		response = [response stringByReplacingOccurrencesOfString:@"@@NAME@@"
													   withString:message.name];
		response = [response stringByReplacingOccurrencesOfString:@"@@MAIL_CAPTION@@"
													   withString:@"Mail:"];
		response = [response stringByReplacingOccurrencesOfString:@"@@MAIL@@"
													   withString:message.mail];
		
		id date = message.dateRepresentation;
		if(!date) {
			date = message.date;
		}
		if(date) {
		response = [response stringByReplacingOccurrencesOfString:@"@@DATE_CAPTION@@"
													   withString:@"Date:"];
		response = [response stringByReplacingOccurrencesOfString:@"@@DATE@@"
													   withString:date];
		}
		
		id identify = message.IDString;
		response = [response stringByReplacingOccurrencesOfString:@"@@ID_CAPTION@@"
													   withString:identify ? @"ID" : @""];
		response = [response stringByReplacingOccurrencesOfString:@"@@ID@@"
													   withString:identify ? identify : @""];
		response = [response stringByReplacingOccurrencesOfString:@"@@CONTENT_CAPTION@@"
													   withString:@"@@CONTENT_CAPTION@@"];
		response = [response stringByReplacingOccurrencesOfString:@"@@CONTENT@@"
													   withString:message.messageSource];
		
		[responses addObject:response];
		
	}
	NSString *body = [bodyTemplate stringByReplacingOccurrencesOfString:@"@@CONTENTS@@"
															 withString:[responses componentsJoinedByString:@"\n"]];
	
	NSString *html = [htmlTemplate stringByReplacingOccurrencesOfString:@"@@HEAD@@"
															 withString:head];
	html = [html stringByReplacingOccurrencesOfString:@"@@BODY@@"
										   withString:body];
	
	return html;
}

@end
