//
//  KMBrowser.h
//  BathyScaphe
//
//  Created by Hori,Masaki on 11/07/18.
//  Copyright 2011 masakih. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "KMLogDocumentWindowController.h"

@class KMBoardList;
@class KMThreadList;
@class KMBSLogViewController;
@class KMStatusLineViewController;
@class KMBrowserDocumentProxy;

@interface KMBrowser : KMLogDocumentWindowController
{
	NSView *boardListPlaceholder;
	KMBoardList *boardList;
	
	NSView *rightView;
	NSView *threadListPlaceholder;
	KMThreadList *threadList;
	
	NSView *bsviewPlaceholder;;
	KMBSLogViewController *bsview;
	
	NSView *progressViewPlaceholder;
	KMStatusLineViewController *progressView;
	
	NSArray *_associatedResponders;
	NSMutableArray *_recentAssociatedResponders;
	NSResponder *_recentFirstResponder; // no retain
	KMBrowserDocumentProxy *_docProxy;
	
	BOOL vAnimation;
	BOOL hAnimation;
	
#if !__LP64__
	NSSearchField *_searchField;
	BOOL _useLogWindow;
#endif
}

@property (assign) IBOutlet NSView *boardListPlaceholder;
@property (assign) IBOutlet NSView *rightView;
@property (assign) IBOutlet NSView *threadListPlaceholder;
@property (assign) IBOutlet NSView *bsviewPlaceholder;
@property (assign) IBOutlet NSView *progressViewPlaceholder;

@property (assign) IBOutlet NSSearchField *searchField;

@property BOOL useLogWindow;

@end

@interface KMBrowser (Actions)
- (IBAction)showBoardList:(id)sender;
- (IBAction)hideBoardList:(id)sender;
- (IBAction)collapseOrExpandBoardList:(id)sender;

- (IBAction)showThreadList:(id)sender;
- (IBAction)hideThreadList:(id)sender;
- (IBAction)collapseOrExpandThreadList:(id)sender;


- (IBAction)openSelectedThreads:(id)sender;
@end
