//
//  KMLogDocumentWindowController.h
//  
//
//  Created by 堀 昌樹 on 11/12/17.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "CMRTask.h"

@class KMDocument;
@class KMLogViewController;

@class CMRThreadAttributes;

@interface KMLogDocumentWindowController : NSWindowController
#if !__LP64__
{
	id<CMRTask> _currentTask;
}
#endif
- (void)overlayView:(NSView *)view on:(NSView *)placeholder;
- (void)replaceAndFit:(NSView *)view with:(NSView *)oldView;

@property (readonly) KMDocument *doc;
@property (readonly) KMLogViewController *logViewController;
@property (readonly) NSString *boardName;
@property (readonly) NSString *threadTitle;

// KMDocument
@property (readonly) NSNumber *numberMessages;

// CMRTaskManager
@property (readonly, retain) id<CMRTask> currentTask;
@property (readonly) NSString *taskTitle;
@property (readonly) NSString *taskMessage;
@property (readonly) BOOL taskInProgress;
@property (readonly) double taskAmount;
- (IBAction)cancelCurrentTask:(id)sender;


// For BSThreadInfoPanelController
@property (readonly) CMRThreadAttributes *threadAttributes;

// for Subclass.
// save lastIndex and windowFrame.
- (void)saveDocumentViewAttributes;
- (void)restoreDocumentViewAttributes;

@end

