//
//  HMWebBrowserChanger.m
//  HMWebBrowserChanger
//
//  Created by Hori,Masaki on 2013/01/10.
//  Copyright (c) 2013 masakih. All rights reserved.
//

#import "HMWebBrowserChanger.h"

#import "HMPreferenceViewController.h"

@interface HMWebBrowserChanger ()
@property (retain) HMPreferenceViewController *viewController;
@end

@implementation HMWebBrowserChanger
@synthesize defaults = _defaults;
@synthesize browserIdentifier = _browserIdentifier;

@synthesize viewController = _viewController;

- (id)initWithPreferences:(AppDefaults *)prefs
{
	self = [super init];
	if(self) {
		self.defaults = prefs;
		_browserIdentifier = [[self preferenceForKey:@"com.masakih.HMWebBrowserChanger.browserIdentifier"] copy];
	}
	return self;
}

// Action
- (BOOL)previewLink:(NSURL *)url
{
	if(!self.browserIdentifier) return NO;
	
	NSWorkspace *ws = [NSWorkspace sharedWorkspace];
	
	return [ws openURLs:[NSArray arrayWithObject:url]
withAppBundleIdentifier:self.browserIdentifier
				options:[self.defaults openInBg] ? NSWorkspaceLaunchWithoutActivation : 0
additionalEventParamDescriptor:nil
	  launchIdentifiers:NULL];
}

- (BOOL)validateLink:(NSURL *)url { return YES; }

- (NSView *)preferenceView
{
	if(!self.viewController) {
		self.viewController = [[[HMPreferenceViewController alloc] init] autorelease];
		[self.viewController bind:@"appIdentifier"
						 toObject:self
					  withKeyPath:@"browserIdentifier"
						  options:nil];
		
		[self.viewController addObserver:self
						  forKeyPath:@"appIdentifier"
							 options:NSKeyValueObservingOptionNew
							 context:self.viewController];
	}
	return [self.viewController view];
}


- (void)setPreference:(id)pref forKey:(id)key
{
	if(!key) {
		[[self.defaults imagePreviewerPrefsDict] removeObjectForKey:key];
		return;
	}
	[[self.defaults imagePreviewerPrefsDict] setObject:pref forKey:key];
}
- (id)preferenceForKey:(id)key
{
	return [[self.defaults imagePreviewerPrefsDict] objectForKey:key];
}

- (NSString *)browserIdentifier
{
	return _browserIdentifier;
}
- (void)setBrowserIdentifier:(NSString *)browserIdentifier
{
	[self setPreference:browserIdentifier forKey:@"com.masakih.HMWebBrowserChanger.browserIdentifier"];
	id tmp = _browserIdentifier;
	_browserIdentifier = [browserIdentifier copy];
	[tmp release];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == self.viewController) {
		if([keyPath isEqualToString:@"appIdentifier"]) {
			self.browserIdentifier = [change objectForKey:NSKeyValueChangeNewKey];
		}
		return;
	}
	
	[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}

@end
