//
//  HMPreferenceViewController.m
//  HMWebBrowserChanger
//
//  Created by Hori,Masaki on 2013/01/10.
//  Copyright (c) 2013年 masakih. All rights reserved.
//

#import "HMPreferenceViewController.h"

@interface HMPreferenceViewController ()

@end

@implementation HMPreferenceViewController

@synthesize appIdentifier = _appIdentifier;

- (id)init
{
	self = [super initWithNibName:@"HMPreferenceViewController" bundle:[NSBundle bundleForClass:[self class]]];
	return self;
}

+ (NSSet *)keyPathsForValuesAffectingAppName
{
	return [NSSet setWithObject:@"appIdentifier"];
}
+ (NSSet *)keyPathsForValuesAffectingIcon
{
	return [NSSet setWithObject:@"appIdentifier"];
}

- (NSString *)appName
{
	if(!self.appIdentifier) return nil;
	NSWorkspace *ws = [NSWorkspace sharedWorkspace];
	NSString *path = [ws absolutePathForAppBundleWithIdentifier:self.appIdentifier];
	NSFileManager *fm = [NSFileManager defaultManager];
	return [fm displayNameAtPath:path];
}
- (NSImage *)icon
{
	if(!self.appIdentifier) return nil;
	NSWorkspace *ws = [NSWorkspace sharedWorkspace];
	NSString *path = [ws absolutePathForAppBundleWithIdentifier:self.appIdentifier];
	return [ws iconForFile:path];
}

- (NSURL *)applicationFolderURL
{
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSApplicationDirectory, NSSystemDomainMask, YES);
	if(!paths &&[paths count] == 0) return nil;
	NSString *path = [paths objectAtIndex:0];
	
	return [NSURL fileURLWithPath:path];
}
- (IBAction)selectBrowser:(id)sender
{
	NSOpenPanel *op = [NSOpenPanel openPanel];
	[op setAllowedFileTypes:[NSArray arrayWithObjects:@"app", nil]];
	[op setAllowsMultipleSelection:NO];
	[op setDirectoryURL:[self applicationFolderURL]];
	
	[op beginSheetModalForWindow:[[self view] window]
			   completionHandler:^(NSInteger result) {
				   if(result != NSOKButton) return;
				   
				   NSURL *appURL = [[op URLs] lastObject];
				   NSBundle *appBundle = [NSBundle bundleWithURL:appURL];
				   if(!appBundle) return;
				   
				   self.appIdentifier = [appBundle bundleIdentifier];
			   }
	 ];
}

@end
