#import "GroEvader.h"

#import "TemporaryFolder.h"

#import <QuartzCore/QuartzCore.h>

#ifdef DEBUG
#define ENTERMETHOD	NSLog(@"Enter Method -> %@", NSStringFromSelector(_cmd))
#else
#define ENTERMETHOD
#endif

static NSString *GroEvaderWidnowRectKey = @"com.masakih.GroEvader.WindowRect";

BOOL isTigerOrLater()
{
	return (floor(NSAppKitVersionNumber) > NSAppKitVersionNumber10_3);
}

void alertPanther()
{
	NSRunAlertPanel( GELocalizedString(@"Alert", @"Alert"),
					 GELocalizedString(@"Sory Panther", @"Sory Panther"),
					 GELocalizedString(@"OK", @"OK"),
					 nil,
					 nil);
}

@implementation GroEvader

// Designated Initializer
- (id) initWithPreferences : (AppDefaults *) prefs
{
	self = [super initWithWindowNibName:NSStringFromClass([self class])];
	
	if(!isTigerOrLater()) {
		alertPanther();
		[self autorelease];
		return nil;
	}
	
	if( self ) {
		downloadFolder = [[TemporaryFolder alloc] init];
		[self setPreferences:prefs];
		[self registNotigications];
	}
	
	return self;
}
-(void)dealloc
{
	[download release];
	[downloadFolder release];
	[lastFileName release];
	
	[super dealloc];
}

-(void)awakeFromNib
{
	pixellate = [[CIFilter filterWithName:@"CIPixellate"] retain];
	[pixellate setDefaults];
	
	[pixellate bind:@"inputImage"
		   toObject:self
		withKeyPath:@"cImage"
			options:nil];
	[pixellate bind:@"inputScale"
		   toObject:self
		withKeyPath:@"scale"
			options:nil];
	
	
	[view setGestureTarget:self];
	[view setGestureAction:@selector(openURL:)];
}

#pragma mark ## BSImagePreviewerProtocol ##
	// Accessor
- (AppDefaults *) preferences
{
	return pref;
}
- (void) setPreferences : (AppDefaults *) aPreferences
{
	pref = aPreferences;
	
	[self window];
	{
		NSString *winRectString = [[pref imagePreviewerPrefsDict] objectForKey:GroEvaderWidnowRectKey];
		if( winRectString ) {
			[[self window] setFrameFromString:winRectString];
		}
	}
}
	// Action
- (BOOL) showImageWithURL : (NSURL *) inImageURL
{
//	id event = [NSApp currentEvent];
//	NSLog(@"Event ---> %@", event);
	///
	[self setImage:nil];
	[self setErrorText:nil];
	[self showWindow:self];
	
	@synchronized(scallingTimer) {
		[scallingTimer invalidate];
		[scallingTimer release];
		scallingTimer = nil;
	}
	
	[self setImageURL:inImageURL];
	[self loadInBackground:inImageURL];
	return YES;
}
- (BOOL) validateLink : (NSURL *) anURL
{
	NSArray *imageExtensions;
	NSString *extension;
	
	extension = [[[anURL path] pathExtension] lowercaseString];
	if( ! extension ) return NO;
	
	imageExtensions = [NSImage imageFileTypes];
	
	return [imageExtensions containsObject:extension];
}

#pragma mark## Download & NSURLDownload Delegate  ##
-(void)loadInBackground:(NSURL *)url
{
	NSURLRequest *request;
	NSString *path;
	
	ENTERMETHOD;
	
	if( download ) {
		[download cancel];
	}
	
	id temp = lastFileName;
	lastFileName = [[[url path] lastPathComponent] retain];
	[temp release];
	[self synchronizeWindowTitleWithDocumentName];
	
	request = [NSURLRequest requestWithURL:url];
	
	download = [[NSURLDownload alloc ] initWithRequest:request delegate:self];
	
	if( download ) {
		path = [[downloadFolder path] stringByAppendingPathComponent:[[url path] lastPathComponent]];
		[download setDestination:path allowOverwrite:YES];
	} else {
		[self setImageURL:nil];
	}
}
- (void)downloadDidBegin:(NSURLDownload *)download
{
	ENTERMETHOD;
	
	[indicator startAnimation:self];
}
- (NSURLRequest *)download:(NSURLDownload *)download willSendRequest:(NSURLRequest *)request redirectResponse:(NSURLResponse *)redirectResponse
{
	if(![self validateLink:[request URL]] ) {
		id error = [NSString stringWithFormat:@"Redirect to non image URL.\n%@",
			[[request URL] absoluteString]];
		[self setErrorText:error];
		return nil;
	}
	
	return request;
}

// - (void)download:(NSURLDownload *)download didReceiveAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge;
// - (void)download:(NSURLDownload *)download didCancelAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge;
// - (void)download:(NSURLDownload *)download didReceiveResponse:(NSURLResponse *)response;
// - (void)download:(NSURLDownload *)download willResumeWithResponse:(NSURLResponse *)response fromByte:(long long)startingByte;
// - (void)download:(NSURLDownload *)download didReceiveDataOfLength:(unsigned)length;
// - (BOOL)download:(NSURLDownload *)download shouldDecodeSourceDataOfMIMEType:(NSString *)encodingType;
// - (void)download:(NSURLDownload *)download decideDestinationWithSuggestedFilename:(NSString *)filename;
// - (void)download:(NSURLDownload *)download didCreateDestination:(NSString *)path
- (void)downloadDidFinish:(NSURLDownload *)aDownload
{
	NSURLRequest *request;
	NSImage *newImage;
	
	ENTERMETHOD;
	
	request = [aDownload request];
	if(!request) goto abort;
	
	NSString *filePath = [[[request URL] path] lastPathComponent];
	
	filePath = [[downloadFolder path] stringByAppendingPathComponent:filePath];
	
	newImage = [[[NSImage alloc] initWithContentsOfFile:filePath] autorelease];
	[self setImage:newImage];
	
	id temp = download;
	download = nil;
	[temp release];
	
	[indicator stopAnimation:self];
	[self setScale:50];
	scallingTimer = [NSTimer scheduledTimerWithTimeInterval:0.2
													 target:self
												   selector:@selector(decrementScale:)
												   userInfo:NULL
													repeats:YES];
	[scallingTimer retain];
	
	return;
	
abort: {
	id temp = download;
	download = nil;
	[temp release];
	
	[indicator stopAnimation:self];
	[self setImageURL:nil];
	[self setScale:1];
}
}
- (void)download:(NSURLDownload *)aDownload didFailWithError:(NSError *)error
{
	id temp = download;
	download = nil;
	[temp release];
	
	[self setErrorText:[error localizedDescription]];
	[indicator stopAnimation:self];
	[self setImageURL:nil];
	[self setScale:1];
}

#pragma mark## Actions ##
- (void)openURL:(id)sender
{
	@synchronized(imageURL) {
		if(!imageURL) return;
		
		[[NSWorkspace sharedWorkspace] openURL:imageURL];
	}
}

#pragma mark## NSTimer action ##
- (void)decrementScale:(id)timer
{
	const int delta = 1;
	
	int s = [self scale];
	if(s == 1) {
		@synchronized(scallingTimer) {
			[timer invalidate];
			[scallingTimer autorelease];
			scallingTimer = nil;
		}
	}
	s -= delta;
	s = s < 1 ? 1 : s;
	[self setScale:s];
}

#pragma mark## Accessor ##
-(void)setScale:(int)newScale
{
	scale = newScale;

	[view setNeedsDisplay:YES];
}
-(int)scale
{
	return scale;
}
-(void)setImage:(NSImage *)newImage
{
	ENTERMETHOD;
	
	id temp = image;
	image = [newImage retain];
	[temp release];
	
	if(image) {
		id rep;
		rep = [NSBitmapImageRep imageRepWithData:[image TIFFRepresentation]];
		rep = [[[CIImage alloc] initWithBitmapImageRep:rep] autorelease];
		[self setCImage:rep];
	} else {
		[self setCImage:nil];
		[self setImageURL:nil];
	}
	
	[view setNeedsDisplay:YES];
	
//	[self showWindow:self];
}
-(NSImage *)image
{
	return image;
}
- (CIImage *)cImage
{
	return cImage;
}
- (void)setCImage:(CIImage *)newCImage
{
	id temp = cImage;
	cImage = [newCImage retain];
	[temp release];
}
- (CIImage *)viewImage
{
	CIImage *viewImage = nil;
	@try {
		viewImage = [pixellate valueForKey:@"outputImage"];
	}
	@catch (id ex) {
		// do noting.
	}
	
	return viewImage;
}
- (NSURL *)imageURL
{
	return imageURL;
}
- (void)setImageURL:(NSURL *)url
{
	id temp = imageURL;
	imageURL = [url retain];
	[temp release];
}

- (void)setErrorText:(NSString *)text
{
	[view setText:text];
}
#pragma mark## NSWindow delegate ##
- (void)windowDidResize:(NSNotification *)notification
{
	[[[self preferences] imagePreviewerPrefsDict] setObject:[[self window] stringWithSavedFrame]
													 forKey:GroEvaderWidnowRectKey];
}
- (void)synchronizeWindowTitleWithDocumentName
{
	id title = [self windowTitleForDocumentDisplayName:NSStringFromClass([self class])];
	
	[[self window] setTitle:title];
}
- (NSString *)windowTitleForDocumentDisplayName:(NSString *)displayName
{
	if( lastFileName ) {
		return [NSString stringWithFormat:@"%@ - %@", displayName, lastFileName];
	}
	
	return displayName;
}
- (void)windowWillClose:(NSNotification *)notification
{
	[self setImage:nil];
}

#pragma mark## Notifications ##
-(void)registNotigications
{
	NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
	
	[nc addObserver:self
		   selector:@selector(applicationWillTerminate:)
			   name:NSApplicationWillTerminateNotification
			 object:nil];
}

-(void)applicationWillTerminate:(id)notification
{
	id temp = downloadFolder;
	downloadFolder = nil;
	[temp release];
}

@end


@implementation MosaicView
- (void)mouseDown:(NSEvent *)theEvent
{
	if([theEvent clickCount] > 1) {
		[[self window] performClose:self];
	}
}

- (void)setText:(NSString *)string
{
	id temp = text;
	text = [string copy];
	[temp release];
	
	[self setNeedsDisplay:YES];
}

- (NSParagraphStyle *)textparagraph
{
	NSMutableParagraphStyle *paragraph = [[[NSParagraphStyle defaultParagraphStyle] mutableCopy] autorelease];
	[paragraph setAlignment:NSCenterTextAlignment];
	
	return paragraph;
}
- (NSDictionary *)textAttributes
{
	NSMutableDictionary *result = [NSMutableDictionary dictionary];
	
	[result setObject:[NSColor redColor]
			   forKey:NSForegroundColorAttributeName];
	[result setObject:[self textparagraph]
			   forKey:NSParagraphStyleAttributeName];
	
	return result;
}
- (void)drawText
{
	if(!text || [text length] == 0) return;
	
	NSRect rect = [self frame];
	NSRect drawRect;
	id attr = [self textAttributes];
	
	drawRect.size = [text sizeWithAttributes:attr];
	
	drawRect.origin.x = ( NSWidth(rect) - NSWidth(drawRect) ) * 0.5;
	drawRect.origin.y = ( NSHeight(rect) - NSHeight(drawRect) ) * 0.5;
	
	[text drawInRect:drawRect
			withAttributes:attr];
}
- (void)drawImage
{
	if(!context) {
		context = [[[NSGraphicsContext currentContext] CIContext] retain];
	}
	if(!context) {
		NSLog(@"Abort!!"); return;
	}
	
	CIImage *cImage = [delegate viewImage];
	if(!cImage) return;
	
	NSRect frame = [self bounds];
	CGRect imageRect = [cImage extent];
	CGRect cg;
	float frameAspect, imageAspect;
	NSRect temp;
	
	frameAspect = NSWidth(frame) / NSHeight(frame);
	imageAspect = CGRectGetWidth(imageRect) / CGRectGetHeight(imageRect);
	
	if(imageAspect > frameAspect) {
		temp = frame;
		temp.size.height = NSWidth(frame) / imageAspect;
		temp.origin.y += (NSHeight(frame) - NSHeight(temp)) / 2;
		frame = temp;
	} else if(imageAspect < frameAspect) {
		temp = frame;
		temp.size.width = NSHeight(frame) * imageAspect;
		temp.origin.x += (NSWidth(frame) - NSWidth(temp)) / 2;
		frame = temp;
	}
	
	cg = CGRectMake(NSMinX(frame), NSMinY(frame),
					NSWidth(frame), NSHeight(frame));
	cg = CGRectInset(cg, 1, 1);
	[context drawImage:cImage
				inRect:cg
			  fromRect:imageRect];
}
- (void)drawRect:(NSRect)rect
{
	[NSGraphicsContext saveGraphicsState];
	[[NSColor whiteColor] set];
	NSRectFill([self bounds]);
	[[NSColor blackColor] set];
	NSFrameRect([self bounds]);
	[NSGraphicsContext restoreGraphicsState];
	
	[self drawImage];
	
	[self drawText];
}
	
@end
