/* GroEvader */

#import <Cocoa/Cocoa.h>

#import "BSImagePreviewerInterface.h"

#import "CircleGestureView.h"

@class TemporaryFolder, CIContext, CIFilter, CIImage;
@class MosaicView;

@interface GroEvader : NSWindowController <BSImagePreviewerProtocol>
{
    IBOutlet NSImage *image;
	IBOutlet id indicator;
	IBOutlet MosaicView *view;
		
	int scale;
	NSURLDownload *download;
	TemporaryFolder *downloadFolder;
	NSString *lastFileName;
	NSURL *imageURL;
		
	CIFilter *pixellate;
	CIImage *cImage;
	
	NSTimer *scallingTimer;
	
	AppDefaults *pref;
}

-(void)setScale:(int)newScale;
-(int)scale;
-(void)setImage:(NSImage *)image;
-(NSImage *)image;

-(void)setCImage:(CIImage *)cImage;
- (CIImage *)cImage;

- (CIImage *)viewImage;

- (NSURL *)imageURL;
- (void)setImageURL:(NSURL *)url;

-(void)registNotigications;

-(void)loadInBackground:(NSURL *)url;

- (void)openURL:(id)sender;

- (void)setErrorText:(NSString *)text;

@end

@interface MosaicView : CircleGestureView
{
	IBOutlet id delegate;
	
	NSString *text;
	
	CIContext *context;
}

- (void)setText:(NSString *)text;
@end

#define GELocalizedString(key, comment) \
	[[NSBundle bundleForClass:[GroEvader class]] localizedStringForKey:(key) value:@"" table:nil]
