//
//  MosaicView.m
//  MosaicPreviewerForThousand
//
//  Created by Hori,Masaki on 07/12/13.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "MosaicView.h"

#import <QuartzCore/QuartzCore.h>

@implementation MosaicView
- (void)mouseDown:(NSEvent *)theEvent
{
	if([delegate isClosePanelWithSingleClick]
	   || [theEvent clickCount] > 1) {
		[[self window] performClose:self];
	}
}

- (void)setText:(NSString *)string
{
	id temp = text;
	text = [string copy];
	[temp release];
	
	[self setNeedsDisplay:YES];
}

- (NSParagraphStyle *)textparagraph
{
	NSMutableParagraphStyle *paragraph = [[[NSParagraphStyle defaultParagraphStyle] mutableCopy] autorelease];
	[paragraph setAlignment:NSCenterTextAlignment];
	
	return paragraph;
}
- (NSDictionary *)textAttributes
{
	NSMutableDictionary *result = [NSMutableDictionary dictionary];
	
	[result setObject:[NSColor redColor]
			   forKey:NSForegroundColorAttributeName];
	[result setObject:[self textparagraph]
			   forKey:NSParagraphStyleAttributeName];
	
	return result;
}
- (void)drawText
{
	if(!text || [text length] == 0) return;
	
	NSRect rect = [self frame];
	NSRect drawRect;
	id attr = [self textAttributes];
	
	drawRect.size = [text sizeWithAttributes:attr];
	
	drawRect.origin.x = ( NSWidth(rect) - NSWidth(drawRect) ) * 0.5;
	drawRect.origin.y = ( NSHeight(rect) - NSHeight(drawRect) ) * 0.5;
	
	[text drawInRect:drawRect
	  withAttributes:attr];
}
- (void)drawImage
{
	if(!context) {
		context = [[[NSGraphicsContext currentContext] CIContext] retain];
	}
	if(!context) {
		NSLog(@"Abort!!"); return;
	}
	
	CIImage *cImage = [delegate viewImage];
	if(!cImage) return;
	
	NSRect frame = [self bounds];
	CGRect imageRect = [cImage extent];
	CGRect cg;
	float frameAspect, imageAspect;
	NSRect temp;
	
	frameAspect = NSWidth(frame) / NSHeight(frame);
	imageAspect = CGRectGetWidth(imageRect) / CGRectGetHeight(imageRect);
	
	if(imageAspect > frameAspect) {
		temp = frame;
		temp.size.height = NSWidth(frame) / imageAspect;
		temp.origin.y += (NSHeight(frame) - NSHeight(temp)) / 2;
		frame = temp;
	} else if(imageAspect < frameAspect) {
		temp = frame;
		temp.size.width = NSHeight(frame) * imageAspect;
		temp.origin.x += (NSWidth(frame) - NSWidth(temp)) / 2;
		frame = temp;
	}
	
	cg = CGRectMake(NSMinX(frame), NSMinY(frame),
					NSWidth(frame), NSHeight(frame));
	cg = CGRectInset(cg, 1, 1);
	[context drawImage:cImage
				inRect:cg
			  fromRect:imageRect];
}
- (void)drawRect:(NSRect)rect
{
	[NSGraphicsContext saveGraphicsState];
	[[NSColor whiteColor] set];
	NSRectFill([self bounds]);
	[[NSColor blackColor] set];
	NSFrameRect([self bounds]);
	[NSGraphicsContext restoreGraphicsState];
	
	[self drawImage];
	
	[self drawText];
}

@end
