//
//  GroEvader.m
//  MosaicPreviewerForThousand
//
//  Created by Hori,Masaki on 06/01/15.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "GroEvader.h"

#import "TemporaryFolder.h"

#import <QuartzCore/QuartzCore.h>

#ifdef DEBUG
#define ENTERMETHOD	NSLog(@"Enter Method -> %@", NSStringFromSelector(_cmd))
#else
#define ENTERMETHOD
#endif

@interface NSObject(GroEvaderDummyForThousand)
+(id)labelItemWithKey:(id)key;
+(id)separateLineItem;
+(id)boolItemWithKey:(id)key title:(id)title info:(id)info;
@end

static NSString *GroEvaderWidnowRectKey = @"com.masakih.GroEvader.WindowRect";
static NSString *GroEvaderCloseWithOneClickKey = @"com.masakih.GroEvader.CloseWithOneClick";
static NSString *GroEvaderCloseWhenOpenImageKey = @"com.masakih.GroEvader.CloseWhenOpenImage";

BOOL isTigerOrLater()
{
	return (floor(NSAppKitVersionNumber) > NSAppKitVersionNumber10_3);
}

void alertPanther()
{
	NSRunAlertPanel( GELocalizedString(@"Alert", @"Alert"),
					 GELocalizedString(@"Sory Panther", @"Sory Panther"),
					 GELocalizedString(@"OK", @"OK"),
					 nil,
					 nil);
}

@implementation GroEvader

// Designated Initializer
- (id) initWithHostType:(HostType)inHostType prefs:(AppDefaults *) prefs
{
	self = [super initWithWindowNibName:@"MosaicWindow"];
	
	if(!isTigerOrLater()) {
		alertPanther();
		[self autorelease];
		return nil;
	}
	
	if( self ) {
		hostType = inHostType;
		downloadFolder = [[TemporaryFolder alloc] init];
		[self setPreferences:prefs];
		[self registNotigications];
	}
	
	return self;
}
- (id) initWithPreferences : (AppDefaults *) prefs
{
	return [self initWithHostType:kHostBathyScaphe prefs:prefs];
}
- (id) init
{
	return [self initWithHostType:kHostThousand prefs:nil];
}
-(void)dealloc
{
	[download release];
	[downloadFolder release];
	[lastFileName release];
	
	[super dealloc];
}

-(void)awakeFromNib
{
	pixellate = [[CIFilter filterWithName:@"CIPixellate"] retain];
	[pixellate setDefaults];
	
	[pixellate bind:@"inputImage"
		   toObject:self
		withKeyPath:@"cImage"
			options:nil];
	[pixellate bind:@"inputScale"
		   toObject:self
		withKeyPath:@"scale"
			options:nil];
	
	
	[view setGestureTarget:self];
	[view setGestureAction:@selector(openURL:)];
}

- (void)fitWindowPosition
{
	NSEvent *event = [NSApp currentEvent];
	NSPoint mouse;
	
	if((NSLeftMouseDown < [event type] && [event type] < NSMouseExited)
	   || (NSOtherMouseDown < [event type] && [event type] < NSOtherMouseDragged)) {
		mouse = [event locationInWindow];
		mouse = [[event window] convertBaseToScreen:mouse];
	} else {
		mouse = [NSEvent mouseLocation];
	}
	
	mouse.y -= 25;
	
	[[self window] setFrameOrigin:mouse];
}

-(id)prefObjectForHost
{
	if(hostType == kHostBathyScaphe) {
		return [pref imagePreviewerPrefsDict];
	} else if(hostType == kHostThousand) {
		return [NSUserDefaults standardUserDefaults];
	}
	
	return nil;
}


#pragma mark ## BSImagePreviewerProtocol ##
	// Accessor
- (AppDefaults *) preferences
{
	return pref;
}
- (void) setPreferences : (AppDefaults *) aPreferences
{
	pref = aPreferences;
	
	[self window];
	{
		NSString *winRectString = [[self prefObjectForHost] objectForKey:GroEvaderWidnowRectKey];
		if( winRectString ) {
			[[self window] setFrameFromString:winRectString];
		}
	}
}
	// Action
- (BOOL) showImageWithURL : (NSURL *) inImageURL
{
	[self setImage:nil];
	[self setErrorText:nil];
	[self showWindow:self];
	
	@synchronized(scallingTimer) {
		[scallingTimer invalidate];
		[scallingTimer release];
		scallingTimer = nil;
	}
	
	[self setImageURL:inImageURL];
	[self loadInBackground:inImageURL];
	return YES;
}
- (BOOL) validateLink : (NSURL *) anURL
{
	NSArray *imageExtensions;
	NSString *extension;
	
	extension = [[[anURL path] pathExtension] lowercaseString];
	if( ! extension ) return NO;
	
	imageExtensions = [NSImage imageFileTypes];
	
	return [imageExtensions containsObject:extension];
}
#pragma mark## T2PluginInterface_v100 ##
+(NSArray *)pluginInstances
{
	id ins = [[[[self class] alloc] init] autorelease];
	
	return [NSArray arrayWithObject:ins];
}	
-(NSString *)uniqueName
{
	return GELocalizedString(@"GroEvader Image Previewer", @"GroEvader Image Previewer");
}
-(NSString *)localizedName
{
	return [self uniqueName];
}
-(NSString *)localizedPluginInfo
{
	return GELocalizedString(@"GroEvader Image Previewer.", @"GroEvader Image Previewer.");
}
-(T2PluginType)pluginType
{
	return T2StandardPlugin;
}
-(int)pluginOrder
{
	return T2PluginOrderLast;
}

-(NSArray *)preferenceItems
{
	Class itemClass = NSClassFromString(@"T2PreferenceItem");
	if(!itemClass) return [NSArray array];
	
	NSMutableArray *result = [NSMutableArray array];
	
	id item;
	
	item = [itemClass labelItemWithKey:@"pluginDescription01"];
	if(item) {
		[result addObject:item];
	}
	item = [itemClass labelItemWithKey:@"pluginDescription02"];
	if(item) {
		[result addObject:item];
	}
	
	item = [itemClass separateLineItem];
	if(item) {
		[result addObject:item];
	}
	
	item = [itemClass boolItemWithKey:@"closePanelWithSingleClick"
								title:GELocalizedString(@"Close panel with single click.", @"closePanelWithSingleClick")
								 info:nil];
	if(item) {
		[result addObject:item];
	}
	item = [itemClass boolItemWithKey:@"closePanelWhenOpenImage"
								title:GELocalizedString(@"Close panel when image opened in default web browser.", @"closePanelWhenOpenImage")
								 info:nil];
	if(item) {
		[result addObject:item];
	}

//	item = [itemClass longDescriptionItemItemWithKey:@"pluginDescription"
//											   title:@"title"];
//	if(item) {
//		[result addObject:item];
//	}
//	item = [itemClass stringItemWithKey:@"pluginDescription"
//								  title:@"title"
//								   info:nil];
//	if(item) {
//		[result addObject:item];
//	}
	
	return result;
}

-(id)closePanelWithSingleClick
{
	return [NSNumber numberWithBool:
		[[self prefObjectForHost] boolForKey:GroEvaderCloseWithOneClickKey]];
}
-(void)setClosePanelWithSingleClick:(id)inNumber
{
	if(hostType != kHostThousand) return;
	[[self prefObjectForHost] setBool:[inNumber boolValue]
							   forKey:GroEvaderCloseWithOneClickKey];
}
-(BOOL)isClosePanelWithSingleClick
{
	return [[self closePanelWithSingleClick] boolValue];
}


-(id)closePanelWhenOpenImage
{
	if(hostType == kHostThousand) {
		return [NSNumber numberWithBool:
			[[self prefObjectForHost] boolForKey:GroEvaderCloseWhenOpenImageKey]];
	}
	return nil;
}
-(void)setClosePanelWhenOpenImage:(id)inNumber
{
	if(hostType == kHostThousand) {
		[[self prefObjectForHost] setBool:[inNumber boolValue]
								   forKey:GroEvaderCloseWhenOpenImageKey];
	}
}
-(BOOL)isClosePanelWhenOpenImage
{
	return [[self closePanelWhenOpenImage] boolValue];
}
-(id)pluginDescription01
{
	return GELocalizedString(@"PluginInfo01", @"PluginInfo");
}
-(void)setPluginDescription01:(id)dummy
{
	//
}
-(id)pluginDescription02
{
	return GELocalizedString(@"PluginInfo02", @"PluginInfo");
}
-(void)setPluginDescription02:(id)dummy
{
	//
}
#pragma mark ## T2URLPreviewing_v100 ##
-(NSArray *)previewableURLHosts
{
	return nil;
}
-(NSArray *)previewableURLExtensions
{
	return [NSImage imageFileTypes];
}
-(BOOL)isPreviewableURLString:(NSString *)urlString type:(T2PreviewType)type
{
	NSString *extension = [[urlString pathExtension] lowercaseString];
	if(!extension) return NO;
	
	return [[self previewableURLExtensions] containsObject:extension];
}
-(NSString *)partialHTMLForPreviewingURLString:(NSString *)urlString
										  type:(T2PreviewType)type
									   minSize:(NSSize *)minSize
{
	NSURL *aImageURL = [NSURL URLWithString:urlString];
	if(!aImageURL) return [NSString stringWithFormat:@"<a href=\"%@\">%@</a>", urlString, urlString];;
	
	
	[self fitWindowPosition];
	[self showImageWithURL:aImageURL];
	
	return @"<body onload=\"javascript:window.close()\"></body>";
}

#pragma mark## Download & NSURLDownload Delegate  ##
-(void)loadInBackground:(NSURL *)url
{
	NSURLRequest *request;
	NSString *path;
	
	ENTERMETHOD;
	
	if( download ) {
		[download cancel];
	}
	
	id temp = lastFileName;
	lastFileName = [[[url path] lastPathComponent] retain];
	[temp release];
	[self synchronizeWindowTitleWithDocumentName];
	
	request = [NSURLRequest requestWithURL:url];
	
	download = [[NSURLDownload alloc ] initWithRequest:request delegate:self];
	
	if( download ) {
		path = [[downloadFolder path] stringByAppendingPathComponent:[[url path] lastPathComponent]];
		[download setDestination:path allowOverwrite:YES];
	} else {
		[self setImageURL:nil];
	}
}
- (void)downloadDidBegin:(NSURLDownload *)download
{
	ENTERMETHOD;
	
	[indicator startAnimation:self];
}
- (NSURLRequest *)download:(NSURLDownload *)download willSendRequest:(NSURLRequest *)request redirectResponse:(NSURLResponse *)redirectResponse
{
	if(![self validateLink:[request URL]] ) {
		id error = [NSString stringWithFormat:@"Redirect to non image URL.\n%@",
			[[request URL] absoluteString]];
		[self setErrorText:error];
		return nil;
	}
	
	return request;
}

// - (void)download:(NSURLDownload *)download didReceiveAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge;
// - (void)download:(NSURLDownload *)download didCancelAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge;
// - (void)download:(NSURLDownload *)download didReceiveResponse:(NSURLResponse *)response;
// - (void)download:(NSURLDownload *)download willResumeWithResponse:(NSURLResponse *)response fromByte:(long long)startingByte;
// - (void)download:(NSURLDownload *)download didReceiveDataOfLength:(unsigned)length;
// - (BOOL)download:(NSURLDownload *)download shouldDecodeSourceDataOfMIMEType:(NSString *)encodingType;
// - (void)download:(NSURLDownload *)download decideDestinationWithSuggestedFilename:(NSString *)filename;
// - (void)download:(NSURLDownload *)download didCreateDestination:(NSString *)path
- (void)downloadDidFinish:(NSURLDownload *)aDownload
{
	NSURLRequest *request;
	NSImage *newImage;
	
	ENTERMETHOD;
	
	request = [aDownload request];
	if(!request) goto abort;
	
	NSString *filePath = [[[request URL] path] lastPathComponent];
	
	filePath = [[downloadFolder path] stringByAppendingPathComponent:filePath];
	
	newImage = [[[NSImage alloc] initWithContentsOfFile:filePath] autorelease];
	[self setImage:newImage];
	
	id temp = download;
	download = nil;
	[temp release];
	
	[indicator stopAnimation:self];
	[self setScale:50];
	scallingTimer = [NSTimer scheduledTimerWithTimeInterval:0.2
													 target:self
												   selector:@selector(decrementScale:)
												   userInfo:NULL
													repeats:YES];
	[scallingTimer retain];
	
	return;
	
abort: {
	id temp = download;
	download = nil;
	[temp release];
	
	[indicator stopAnimation:self];
	[self setImageURL:nil];
	[self setScale:1];
}
}
- (void)download:(NSURLDownload *)aDownload didFailWithError:(NSError *)error
{
	id temp = download;
	download = nil;
	[temp release];
	
	[self setErrorText:[error localizedDescription]];
	[indicator stopAnimation:self];
	[self setImageURL:nil];
	[self setScale:1];
}

#pragma mark## Actions ##
- (void)openURL:(id)sender
{
	@synchronized(imageURL) {
		if(!imageURL) return;
		
		[[NSWorkspace sharedWorkspace] openURL:imageURL];
	}
	if([self isClosePanelWhenOpenImage]) {
		[[self window] performClose:self];
	}
}

#pragma mark## NSTimer action ##
- (void)decrementScale:(id)timer
{
	const int delta = 1;
	
	int s = [self scale];
	if(s == 1) {
		@synchronized(scallingTimer) {
			[timer invalidate];
			[scallingTimer autorelease];
			scallingTimer = nil;
		}
	}
	s -= delta;
	s = s < 1 ? 1 : s;
	[self setScale:s];
}

#pragma mark## Accessor ##
-(void)setScale:(int)newScale
{
	scale = newScale;

	[view setNeedsDisplay:YES];
}
-(int)scale
{
	return scale;
}
-(void)setImage:(NSImage *)newImage
{
	ENTERMETHOD;
	
	id temp = image;
	image = [newImage retain];
	[temp release];
	
	if(image) {
		id rep;
		rep = [NSBitmapImageRep imageRepWithData:[image TIFFRepresentation]];
		rep = [[[CIImage alloc] initWithBitmapImageRep:rep] autorelease];
		[self setCImage:rep];
	} else {
		[self setCImage:nil];
		[self setImageURL:nil];
	}
	
	[view setNeedsDisplay:YES];
}
-(NSImage *)image
{
	return image;
}
- (CIImage *)cImage
{
	return cImage;
}
- (void)setCImage:(CIImage *)newCImage
{
	id temp = cImage;
	cImage = [newCImage retain];
	[temp release];
}
- (CIImage *)viewImage
{
	CIImage *viewImage = nil;
	@try {
		viewImage = [pixellate valueForKey:@"outputImage"];
	}
	@catch (id ex) {
		// do noting.
	}
	
	return viewImage;
}
- (NSURL *)imageURL
{
	return imageURL;
}
- (void)setImageURL:(NSURL *)url
{
	id temp = imageURL;
	imageURL = [url retain];
	[temp release];
}

- (void)setErrorText:(NSString *)text
{
	[view setText:text];
}
#pragma mark## NSWindow delegate ##
- (void)windowDidResize:(NSNotification *)notification
{
	[[self prefObjectForHost] setObject:[[self window] stringWithSavedFrame]
								 forKey:GroEvaderWidnowRectKey];
}
- (void)synchronizeWindowTitleWithDocumentName
{
	id title = [self windowTitleForDocumentDisplayName:NSStringFromClass([self class])];
	
	[[self window] setTitle:title];
}
- (NSString *)windowTitleForDocumentDisplayName:(NSString *)displayName
{
	if( lastFileName ) {
		return [NSString stringWithFormat:@"%@ - %@", displayName, lastFileName];
	}
	
	return displayName;
}
- (void)windowWillClose:(NSNotification *)notification
{
	[self setImage:nil];
}

#pragma mark## Notifications ##
-(void)registNotigications
{
	NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
	
	[nc addObserver:self
		   selector:@selector(applicationWillTerminate:)
			   name:NSApplicationWillTerminateNotification
			 object:nil];
}

-(void)applicationWillTerminate:(id)notification
{
	id temp = downloadFolder;
	downloadFolder = nil;
	[temp release];
}

@end


