//
//  HMDocument.m
//  testAVFoundation
//
//  Created by 堀 昌樹 on 12/06/07.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "HMDocument.h"

#import <AVFoundation/AVFoundation.h>

@interface HMDocument ()
{
	AVURLAsset *asset;
	AVPlayerItem *item;
	AVPlayer *player;
}

@end

@implementation HMDocument
@synthesize view;
@synthesize playButton;

- (void)dealloc
{
	[player release];
	[item removeObserver:self forKeyPath:@"status"];
	[item release];
	[asset release];
	[super dealloc];
}

- (NSString *)windowNibName
{
	// Override returning the nib file name of the document
	// If you need to use a subclass of NSWindowController or if your document supports multiple NSWindowControllers, you should remove this method and override -makeWindowControllers instead.
	return @"HMDocument";
}

- (void)windowControllerDidLoadNib:(NSWindowController *)aController
{
	[super windowControllerDidLoadNib:aController];
	// Add any code here that needs to be executed once the windowController has loaded the document's window.
	
	[self syncUI];
}


- (BOOL)readFromURL:(NSURL *)url ofType:(NSString *)typeName error:(NSError **)outError
{
	asset = [[AVURLAsset URLAssetWithURL:url options:nil] retain];
	
	NSString *tracksKey = @"tracks";
	[asset loadValuesAsynchronouslyForKeys:[NSArray arrayWithObject:tracksKey]
						 completionHandler:
	 ^ {
		 dispatch_async(dispatch_get_main_queue(),
						^{
							item = [[AVPlayerItem playerItemWithAsset:asset] retain];
							[item addObserver:self
								   forKeyPath:@"status"
									  options:0
									  context:item];
							player = [[AVPlayer playerWithPlayerItem:item] retain];
							
							AVPlayerLayer *layer = [AVPlayerLayer playerLayerWithPlayer:player];
							[view setWantsLayer:YES];
							[view setLayer:layer];
						});
		 
	 }];
	
	return asset ? YES : NO;
	
}

- (void)syncUI
{
    if ((player.currentItem != nil) &&
        ([player.currentItem status] == AVPlayerItemStatusReadyToPlay)) {
        playButton.enabled = YES;
    }
    else {
        playButton.enabled = NO;
    }
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == item) {
		dispatch_async(dispatch_get_main_queue(),
                       ^{
                           [self syncUI];
                       });
        return;
	}
}

- (IBAction)play:(id)sender
{
	[player play];
}
@end
