//
//  ZBarScanner.h
//  Barcode Scanner
//
//  Created by Chris Karr on 1/20/10.
//  Copyright 2010 Audacious Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "SampleCIView.h"
#import "zbar.h"


@interface ZBarScanner : NSObject 
{
	zbar_image_t * zImage;
	zbar_image_scanner_t *scanner;
	SampleCIView *previewView;

	float intialOffsetMultiplier;
}

- (id)initWithDataBuffer:(unsigned char *)grayScale height:(NSInteger)heightOfImage width:(NSInteger)widthOfImage;
- (NSString *)scan;
- (void)setPreviewView:(SampleCIView *)aView;



@end
