//
//  BEGeneralPreference.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/03/25.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEGeneralPreference.h"
#import "BERegisterSite.h"
#import "BEPreference.h"
#import "BEExporterAttribute.h"


@interface BEGeneralPreference (BEPrivate)
- (void)setSelection:(id)newSelection;
@end

@implementation BEGeneralPreference

- (id)init
{
	self = [super initWithNibName:@"GeneralPreference" bundle:nil];
	if(self) {
		[self setTitle:NSLocalizedString(@"General", @"General")];
		sites = [[BERegisterSite sites] retain];
		attributes = [[BEExporterAttribute attributes] retain];
		[self setSelection:[attributes objectAtIndex:0]];
	}
	return self;
}
- (void)dealloc
{
	[sites release];
	[attributes release];
	[self setSelection:nil];
	[super dealloc];
}

- (void)setSelection:(id)newSelection
{
	if(selection == newSelection) return;
	
	if(selection) {
		[selection removeObserver:self forKeyPath:@"isOpenAfterExport"];
		[selection removeObserver:self forKeyPath:@"site"];
	}		
	id temp = selection;
	selection = [newSelection retain];
	[temp release];
	
	[selection addObserver:self forKeyPath:@"isOpenAfterExport" options:0 context:NULL];
	[selection addObserver:self forKeyPath:@"site" options:0 context:NULL];
}
- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(![keyPath isEqualToString:@"isOpenAfterExport"] && ![keyPath isEqualToString:@"site"]) {
		return [super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
	}
	
	[BEPreference preference].attributes = attributes;
}

- (NSString *)iconName
{
	return NSImageNamePreferencesGeneral;
}
	
@end
