//
//  BEUserDefaultsKeys.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/03/27.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEPreference.h"


NSString *const BEOpenAfterExported = @"openAfterExported";
NSString *const BEOpenSite = @"targetSite";

NSString *const BEDoNotCheckExport = @"doNotCheckExport";

NSString *const BEAutoLookup = @"autoLookUp";

static NSString *const BESiteOpenAttributes = @"SiteOpenAttributes";

@implementation BEPreference
static BEPreference *sharedInstance = nil;

+ (BEPreference *)preference
{
	if(sharedInstance) return sharedInstance;
	
	sharedInstance = [[BEPreference alloc] init];
	return sharedInstance;
}

- (id)objectForKey:(NSString *)key
{
	NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];
	return [ud objectForKey:key];
}
- (void)setObject:(id)object forKey:(NSString *)key
{
	NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];
	[ud setObject:object forKey:key];
}

- (NSArray *)attributes
{
	NSData *data = [self objectForKey:BESiteOpenAttributes];
	if(!data) return nil;
	return [NSKeyedUnarchiver unarchiveObjectWithData:data];
}
- (void)setAttributes:(NSArray *)attributes
{
	NSData *data = [NSKeyedArchiver archivedDataWithRootObject:attributes];
	[self setObject:data forKey:BESiteOpenAttributes];
}

- (NSNumber *)exportType
{
	NSNumber *type = [self objectForKey:@"exportType"];
	if(!type) {
		type = [NSNumber numberWithInteger:0];
	}
	return type;
}
- (void)setExportType:(NSNumber *)exportType
{
	[self setObject:exportType forKey:@"exportType"];
}

- (BOOL)autoLookUp
{
	id val = [self objectForKey:BEAutoLookup];
	return [val boolValue];
}
- (void)setAutoLookUp:(BOOL)flag
{
	[self setObject:[NSNumber numberWithBool:flag]
			 forKey:BEAutoLookup];
}

- (BOOL)doNotCheckExport
{
	id val = [self objectForKey:BEDoNotCheckExport];
	return [val boolValue];
}
- (void)setDoNotCheckExport:(BOOL)flag
{
	[self setObject:[NSNumber numberWithBool:flag]
			 forKey:BEDoNotCheckExport];
}
@end
