//
//  AdAlphaZero.m
//  AdAlphaZero
//
//  Created by Hori,Masaki on 2015/03/09.
//  Copyright (c) 2015年 Hori,Masaki. All rights reserved.
//

#import "AdAlphaZero.h"

#import "AAZPreferenceViewController.h"


@interface NSWindowController (AAZMethods)
+ (instancetype)sharedInstance;
@end

@interface AdAlphaZero ()

@property (strong) NSNumber *alpha;

@property (strong) AAZPreferenceViewController *preferenceViewController;
@property (weak) id preferences;
@end

@implementation AdAlphaZero

NSWindow *targetWindow()
{
	return [[NSClassFromString(@"BSAdWindowController") sharedInstance] window];
}
void setAlphaToTargetWindow(CGFloat alpha)
{
	BOOL isVisible = targetWindow().isVisible;
	targetWindow().alphaValue = alpha;
	if(!isVisible) [targetWindow() orderOut:nil];
}

+ (void)load
{
	targetWindow().alphaValue = 0.0;
	[targetWindow() orderOut:nil];
}

- (NSView *)preferenceView
{
	if(self.preferenceViewController) return self.preferenceViewController.view;
	
	self.preferenceViewController = [AAZPreferenceViewController new];
	self.preferenceViewController.alpha = self.alpha;
	[self.preferenceViewController addObserver:self
									forKeyPath:@"alpha"
									   options:NSKeyValueObservingOptionNew
									   context:NULL];
	
	return self.preferenceViewController.view;
}

- (NSMutableDictionary *)prefDict
{
	return [self.preferences previewerPrefsDict];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(![keyPath isEqualToString:@"alpha"]) return;
	
	self.alpha = self.preferenceViewController.alpha;
	setAlphaToTargetWindow(self.alpha.doubleValue);
	
	if(self.alpha) {
		self.prefDict[@"com.masakih.AdAlphaZero.alpha"] = self.alpha;
	}
}

- (id)initWithPreferences:(AppDefaults *)prefs
{
	self = [super init];
	if(self) {
		_preferences = prefs;
		_alpha = self.prefDict[@"com.masakih.AdAlphaZero.alpha"];
		targetWindow().alphaValue = self.alpha.doubleValue;
	}
	return self;
}
- (BOOL)previewLink:(NSURL *)url { return NO; }
- (BOOL)validateLink:(NSURL *)url { return NO; }
- (BOOL)previewLinks:(NSArray *)urls { return NO; }
@end
