/*
	NXE`FbNTt_vXg\vO (csdump.c)
	Programmed by maruhiro
*/

#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>

#define FALSE	0
#define TRUE	1
#ifndef O_BINARY
#	define O_BINARY	0
#endif

typedef unsigned char byte;

/*
	16bytes(1s)\.
*/
void *disp16(byte *vsum, const byte *buf, unsigned long addr, int width, int size)
{
	byte sum = 0;
	int i;
	const byte *p;
	byte *q = vsum;

	if(size <= 0)
		return vsum;

	printf("%08lx ", addr);
	for(p = buf; p != buf + size; p++) {
		printf("%02x ", *p);
		sum += *p;
		*q++ += *p;
	}
	for(i = 0; i != width - size; i++)
		printf("~~ ");
	printf(":%02x  ", sum);

#if defined(TEXT)
	for(p = buf; p != buf + size; p++) {
		if(isprint(*p))
			printf("%c", *p);
		else
			printf(".");
	}
#endif
	printf("\n");

	return vsum;
}

/*
	csum\.
*/
void dispvsum(const byte *vsum, int width)
{
	byte sum = 0;
	const byte *p;

	printf("    Sum: ");
	for(p = vsum; p != vsum + width; p++) {
		printf("%02x ", *p);
		sum += *p;
	}
	printf(":%02x\n", sum);
}

/*
	256bytes\.
*/
void disp256(const byte *buf, unsigned long addr, int width, int size)
{
	byte vsum[16] = {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	};
	const byte *p;

	printf("%.*s", 8 + width * 3, "Address  +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +a +b +c +d +e +f");
	printf("%.*s\n", 6 + width, " :Sum 0123456789abcdef");
	
	for(p = buf; p != buf + (size / width) * width ; p += width) {
		disp16(vsum, p, addr, width, width);
		addr += width;
	}
	disp16(vsum, p, addr, width, size % width);

	printf("%.*s\n", 12 + width * 3, "-------------------------------------------------------------");
	dispvsum(vsum, width);
	printf("\n");
}

/*
	_vXg\.
*/
int disp(const char *file, int width)
{
	int fd, size, page_size = width * 16;
	unsigned long addr = 0;
	byte buf[256];

	if((fd = open(file, O_RDONLY | O_BINARY)) != -1) {
		while((size = read(fd, buf, page_size)) > 0) {
			disp256(buf, addr, width, size);
			addr += page_size;
		}
		close(fd);
		return TRUE;
	} else
		return FALSE;
}

int main(int argc, char *argv[])
{
	int i, width = 16;

	if(argc == 1) {
		fprintf(stderr, "Usage: %s -16|-8 [FILE]\n", argv[0]);
		return 1;
	}

	for(i = 1; i < argc; i++) {
		if(strcasecmp(argv[i], "-16") == 0)
			width = 16;
		else if (strcasecmp (argv[i], "-8") == 0)
			width = 8;
		else
			break;
	}

	if(!disp(argv[i], width)) {
		fprintf(stderr, "Cannot open file.\n");
		return 1;
	}
	return 0;
}

/* eof */
