#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

int mock_vsnprintf2(
    char * restrict str __attribute__((unused)), size_t size,
    const char * restrict format __attribute__((unused)),
    va_list ap __attribute__((unused)))
{
    return size - 2;
}

static int free_count;

void mock_free(void *ptr __attribute__((unused)))
{
    free_count++;
}

void cut_setup(void)
{
    mockable_vsnprintf2 = mock_vsnprintf2;
    mockable_free = mock_free;
    free_count = 0;
}

void cut_teardown(void)
{
    mockable_vsnprintf2 = vsnprintf;
    mockable_free = free;
}

void test_vsnprintf2_error_case(void)
{
    char *str;
    int size = asprintf(&str, "ABCDEFG");
    cut_assert_equal_int(-1, size);
    cut_assert_null(str);
    cut_assert_equal_int(1, free_count);
}
