package jp.co.tryjunit.s19_2;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class EmployeeMatcher extends BaseMatcher<Employee> {
	private Employee expected;
	private Employee actualEmployee;
	private String field;

	public EmployeeMatcher(Employee expected) {
		this.expected = expected;
	}

	@Override
	public boolean matches(Object actual) {
		if (expected == null) {
			return actual == null;
		}
		if (!(actual instanceof Employee)) {
			return false;
		}
		actualEmployee = (Employee) actual;

		if (!expected.firstName.equals(actualEmployee.firstName)) {
			field = "firstName";
			return false;
		}
		if (!expected.lastName.equals(actualEmployee.lastName)) {
			field = "lastName";
			return false;
		}
		if (!expected.email.equals(actualEmployee.email)) {
			field = "email";
			return false;
		}
		return true;
	}

	@Override
	public void describeTo(Description desc) {
		desc.appendValue(expected);
		if (expected != null) {
			desc.appendText(", 不一致箇所 " + field + ", 実測値 ").appendValue(
					actualEmployee);
		}
	}

	public static EmployeeMatcher employee(Employee expected) {
		return new EmployeeMatcher(expected);
	}

}
