package jp.co.tryjunit.s18_5;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(Enclosed.class)
public class ItemStockTest {

	public static class InitStatus {
		private ItemStock sut;
		private Item item;

		@Before
		public void setUp() throws Exception {
			sut = new ItemStock();
			item = new Item("book", 3800);
		}

		@Test
		public void testGetNum() throws Exception {
			// 準備
			// テスト実行
			int actual = sut.getNum(item);
			// 検証
			assertThat(actual, is(0));
		}

		@Test
		public void testAdd() throws Exception {
			// 準備
			// テスト実行
			sut.add(item);
			int actual = sut.getNum(item);
			// 検証
			assertThat(actual, is(1));
		}

	}

	public static class OneItemStatus {
		private ItemStock sut;
		private Item item;

		@Before
		public void setUp() throws Exception {
			item = new Item("book", 3800);
			sut = new ItemStock();
			sut.add(item);
		}

		@Test
		public void testGetNum() throws Exception {
			// 準備
			// テスト実行
			int actual = sut.getNum(item);
			// 検証
			assertThat(actual, is(1));
		}

		@Test
		public void testAdd_001() throws Exception {
			// 準備
			// テスト実行
			sut.add(item);
			int actual = sut.getNum(item);
			// 検証
			assertThat(actual, is(2));
		}

		@Test
		public void testAdd_002() throws Exception {
			// 準備
			Item item2 = new Item("bike", 57000);
			// テスト実行
			sut.add(item2);
			int actual = sut.getNum(item2);
			// 検証
			assertThat(actual, is(1));
		}

	}
}
