package jp.co.tryjava.jaxb;

import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.*;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXB;

import org.junit.Test;

/**
 * JAXB（Java Architecture for XML Binding）を使ってみる練習です。
 * <p>
 * ・JAXB（Java Architecture for XML Binding）<br/>
 * ・Java SE 6 以降で使えます。<br/>
 * </p>
 */
public class JaxbTest {

    @Test
    public void testMarshal() {
        // 準備

        // 入力オブジェクト
        Person person = new Person();
        person.name = "山田 太郎";
        person.age = 20;

        // 期待値
        String expected = "" //
                + "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
                + "<person>\n" //
                + "    <name>山田 太郎</name>\n" //
                + "    <age>20</age>\n" //
                + "</person>\n" //
        ;

        // 出力先
        StringWriter sw = new StringWriter();

        // 実行
        JAXB.marshal(person, sw);

        // 検証
        assertThat(sw.toString(), is(expected));
    }

    @Test
    public void testUnmarshal() {
        // 準備

        // 入力XML
        String input = "" //
                + "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
                + "<person>\n" //
                + "    <name>山田 太郎</name>\n" //
                + "    <age>20</age>\n" //
                + "</person>\n" //
        ;
        StringReader sr = new StringReader(input);

        // 実行
        Person actual = JAXB.unmarshal(sr, Person.class);

        // 検証
        assertThat(actual.name, is("山田 太郎"));
        assertThat(actual.age, is(20));
    }

}
