package example.tryspring.cb2_oxm;

import java.io.File;
import java.io.IOException;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * 「付録B.2 Object/XMLマッピング連携」用のメインクラスです。
 * 書籍では、具体的なコーディング例が、applicationContext.xmlのみでした。 その他の部分は、調べながら作成しました。
 */
public class ChapterB2Main {

	private static final String WORK_DIR = "tmp/cb2";

	public static void main(String[] args) throws IOException {
		ChapterB2Main main = new ChapterB2Main();
		main.run();
	}

	private void run() throws IOException {
		ApplicationContext appContext = new ClassPathXmlApplicationContext(
				"example/tryspring/cb2_oxm/applicationContext.xml");
		ProductXml oxm = appContext.getBean(ProductXml.class);

		File dir = new File(WORK_DIR);
		if (dir.mkdirs()) {
			print("作業ディレクトリを作成しました。");
		}

		oxm.save(WORK_DIR + "/cb2_product.xml", new Product("ホッチキス", 100));
		File file = new File(WORK_DIR + "/cb2_product.xml");
		print("ファイルを保存しました。path=" + file.getAbsolutePath());

		Product product = oxm.load(WORK_DIR + "/cb2_product.xml");
		print("ファイルを読み込みました。product=" + product);
	}

	private void print(String msg) {
		System.out.println(msg);
	}
}
