package example.tryspring.c5_transaction;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * 「第5章 ビジネスロジック層の設計と実装」用のメインクラスです。
 */
public class Chapter5Main {

	public static void main(String[] args) {
		Chapter5Main main = new Chapter5Main();
		main.run();
	}

	private void run() {
		ApplicationContext appContext = new ClassPathXmlApplicationContext(
				"/example/tryspring/c5_transaction/applicationContext.xml");
		ProductService service = appContext.getBean(ProductService.class);

		// SELECT
		printSep();
		service.queryForCount();
		printSep();
		service.queryForData();
		printSep();

		// INSERT
		service.updateForInsert();
		printSep();
		service.queryForCount();
		printSep();

		// UPDATE省略

		// DELETE
		service.updateForDelete();
		printSep();
		service.queryForCount();
		printSep();

		// INSERT（例外発生）
		try {
			service.updateForInsertThrowException();
		} catch (RuntimeException e) {
			print(e.getMessage());
		}
		printSep();
		service.queryForCount();
		printSep();

	}

	private void printSep() {
		print("---");
	}

	private void print(String msg) {
		System.out.println(msg);
	}

}
