package example.tryspring.c4_db;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

/**
 * 動作確認のため、ProductDaoクラスの処理状況をログ出力するクラスです。
 */
@Aspect
@Component
public class ProductDaoAspect {

	private Logger logger;

	public ProductDaoAspect() {
		logger = Logger.getLogger(ProductDaoAspect.class);
	}

	@Before("execution(* ProductDao.count(..))"
			+ " || execution(* ProductDao.find(..))"
			+ " || execution(* ProductDao.findAll(..))"
			+ " || execution(* ProductDao.insert(..))"
			+ " || execution(* ProductDao.delete(..))")
	public void before(JoinPoint jp) {
		Signature sig = jp.getSignature();
		String name = sig.getDeclaringTypeName() + "#" + sig.getName() + "メソッド";
		String args = StringUtils.join(jp.getArgs(), ",");
		logger.debug(name + " 開始 args=" + args);
	}

	@AfterReturning(value = "execution(* ProductDao.count(..))"
			+ " || execution(* ProductDao.insert(..))"
			+ " || execution(* ProductDao.delete(..))", returning = "count")
	public void afterReturning(JoinPoint jp, int count) {
		Signature sig = jp.getSignature();
		String name = sig.getDeclaringTypeName() + "#" + sig.getName() + "メソッド";
		logger.debug(name + " 終了 count=" + count);
	}

	@AfterReturning(value = "execution(* ProductDao.find(..))", returning = "product")
	public void afterReturning(JoinPoint jp, Product product) {
		Signature sig = jp.getSignature();
		String name = sig.getDeclaringTypeName() + "#" + sig.getName() + "メソッド";
		logger.debug(name + " 終了 product=" + product);
	}

	@AfterReturning(value = "execution(* ProductDao.findAll(..))", returning = "products")
	public void afterReturning(JoinPoint jp, List<Product> products) {
		Signature sig = jp.getSignature();
		String name = sig.getDeclaringTypeName() + "#" + sig.getName() + "メソッド";
		String productsStr = StringUtils.join(products, ",");
		logger.debug(name + " 終了 products=" + productsStr);
	}

}
