package example.tryspring.c4_db;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * 「第4章 データアクセス層の設計と実装」用のメインクラスです。
 */
public class Chapter4Main {

	public static void main(String[] args) {
		Chapter4Main main = new Chapter4Main();
		main.run();
	}

	private void run() {
		ApplicationContext appContext = new ClassPathXmlApplicationContext(
				"/example/tryspring/c4_db/applicationContext.xml");
		ProductDao dao = appContext.getBean(ProductDao.class);

		// SELECT
		print("count=" + dao.count());
		print("product=" + dao.find("ホッチキス"));
		int i = 0;
		for (Product product : dao.findAll()) {
			print("product(" + i + ")=" + product);
		}

		// INSERT
		print("insert=" + dao.insert(new Product("定規", 50)));
		print("count=" + dao.count());

		// UPDATE省略

		// DELETE
		print("delete=" + dao.delete(new Product("定規", 0)));
		print("count=" + dao.count());
	}

	private void print(String msg) {
		System.out.println(msg);
	}
}
