package example.tryspring.c3_aop_annotation;

import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

import example.tryspring.c2_di.Product;

/**
 * Aspectクラス.
 */
@Aspect
@Component
public class MyFirstAspect {
	@Before("execution(* findProduct(String))")
	public void before() {
		System.out.println("MyFirstAspect#beforeメソッド");
	}

	@Before("execution(* findProduct(String))")
	public void before2(JoinPoint jp) {
		Signature sig = jp.getSignature();
		String name = sig.getName();
		String args = StringUtils.join(jp.getArgs(), ",");
		System.out.println("MyFirstAspect#before2メソッド" + " メソッド名=" + name
				+ " 引数=" + args);
	}

	@After("execution(* findProduct(String))")
	public void after() {
		System.out.println("MyFirstAspect#afterメソッド");
	}

	@After("execution(* findProduct(String))")
	public void after2(JoinPoint jp) {
		Signature sig = jp.getSignature();
		String name = sig.getName();
		String args = StringUtils.join(jp.getArgs(), ",");
		System.out.println("MyFirstAspect#after2メソッド" + " メソッド名=" + name
				+ " 引数=" + args);
	}

	@Around("execution(* findProduct(String))")
	public Product around(ProceedingJoinPoint pjp) throws Throwable {
		System.out.println("MyFirstAspect#aroundメソッド 開始");
		Product product = (Product) pjp.proceed();
		System.out.println("MyFirstAspect#aroundメソッド 終了");
		return product;
	}

	@AfterReturning(value = "execution(* findProduct(String))", returning = "product")
	public void afterReturning(Product product) {
		System.out.println("MyFirstAspect#afterReturningメソッド product="
				+ product.toString());
	}

	@AfterThrowing(value = "execution(* findProduct(String))", throwing = "ex")
	public void afterThrowing(Throwable ex) {
		System.out.println("MyFirstAspect#afterThrowingメソッド ex="
				+ ex.toString());
	}

}
