package example.tryspring.c2_di_annotation;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import example.tryspring.c2_di.Product;
import example.tryspring.c2_di.ProductService;

/**
 * Javaアプリケーションとして実行するクラス.
 */
public class ProductSampleRun {

	public static void main(String[] args) {
		ProductSampleRun productSampleRun = new ProductSampleRun();
		productSampleRun.execute();
	}

	public void execute() {
		ApplicationContext ctx = new ClassPathXmlApplicationContext(
				"/example/tryspring/c2_di_annotation/applicationContext.xml");
		ProductService productService = ctx.getBean(ProductService.class);
		Product product = productService.findProduct();
		System.out.println(product);
	}

}
