package com.tryjava.util;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Base64.Decoder;
import java.util.Base64.Encoder;

/**
 * Java8から導入されたBase64を使ってみる。
 */
public class Base64Java {

	public static void main(String[] args) {
		new Base64Java().run();
	}

	public void run() {
		step01();
	}

	private void step01() {
		try {
			Encoder encoder = Base64.getEncoder();
			byte[] encoded = encoder.encode("こんにちは".getBytes("UTF-8"));
			System.out.println(new String(encoded));

			Decoder decoder = Base64.getDecoder();
			byte[] decoded = decoder.decode(encoded);
			System.out.println(new String(decoded, "UTF-8"));

		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
}
