package com.tryjava.net;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Apache HttpComponents HttpClient 4.3以降）
 *
 * まずはシンプルにアクセスしてみる。
 *
 * 参考<br>
 * JavaでのHttpClientサンプル - CLOVER
 * http://d.hatena.ne.jp/Kazuhira/20131026/1382796711<br>
 * Apache HttpComponents - HttpClient Quick Start
 * http://hc.apache.org/httpcomponents-client-4.5.x/quickstart.html<br>
 *
 * @since 2016/5/26
 */
public class ApacheHttpClient01 {

	public void run() {
		doGet();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		// Java7からtry-with-resourcesが使用可能
		try (CloseableHttpClient client = HttpClients.createDefault()) {

			// リクエスト作成
			HttpGet request = new HttpGet("http://localhost:8080/tryjava-dummy-web/echo");

			// 接続
			// Java7からtry-with-resourcesが使用可能
			try (CloseableHttpResponse response = client.execute(request)) {

				// レスポンスコード取得
				StatusLine statusLine = response.getStatusLine();
				System.out.println(statusLine);
				if (statusLine.getStatusCode() != HttpStatus.SC_OK) {
					throw new RuntimeException("エラーレスポンスを受信しました。statusLine=" + statusLine);
				}

				// レスポンスボディ取得
				HttpEntity entity = response.getEntity();
				String content = EntityUtils.toString(entity);
				System.out.println(content);
			}
		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}
}
