package com.tryjava.lang.lambda;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

/**
 * ラムダ式を使ってみる。
 *
 * コレクションの全要素を処理する。
 *
 * @since 2016/4/29
 */
public class Lambda03 {
	static List<String> list;

	public static void main(String[] args) {
		list = new ArrayList<String>();
		list.add("おはよう");
		list.add("こんにちは");
		list.add("こんばんは");

		// 従来の書き方
		step0a();
		step0b();

		// Java8での書き方
		step1();
		step2();
		step3();
	}

	/**
	 * Java1.4での書き方
	 */
	private static void step0a() {
		@SuppressWarnings("rawtypes")
		Iterator ite = list.iterator();
		while (ite.hasNext()) {
			String str = (String) ite.next();
			System.out.println(str);
		}
	}

	/**
	 * Java5での書き方
	 */
	private static void step0b() {
		for (String e : list) {
			System.out.println(e);
		}
	}

	/**
	 * Java8での書き方（関数型インタフェース）
	 */
	private static void step1() {
		list.forEach(new Consumer<String>() {
			@Override
			public void accept(String str) {
				System.out.println(str);
			}
		});
	}

	/**
	 * Java8での書き方（ラムダ式）
	 */
	private static void step2() {
		list.forEach((str) -> {
			System.out.println(str);
		});
	}

	/**
	 * Java8での書き方（ラムダ式、メソッド参照）
	 */
	private static void step3() {
		list.forEach(System.out::println);
	}
}
