package com.tryjava.ext.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * JAXB（Java Architecture for XML Binding）を使ってみる練習です。
 * <p>
 * ・JAXB（Java Architecture for XML Binding）<br/>
 * ・Java SE 6 以降で使えます。<br/>
 * </p>
 */
public class Jaxb02Jp {
	public void run() throws IOException, JAXBException {
		marshal();
		unmarshal();
		marshalWithEncode();
		unmarshalWithEncode();
	}

	/**
	 * タグ名に日本語を使うXMLを出力する練習です。
	 */
	String marshal() {
		// 入力オブジェクト
		PersonJp person = new PersonJp();
		person.name = "山田 太郎";
		person.age = 20;

		// 実行
		StringWriter sw = new StringWriter();
		JAXB.marshal(person, sw);
		String xml = sw.toString();
		System.out.println(xml);

		return xml;
	}

	/**
	 * タグ名に日本語を使うXMLを読み込む練習です。
	 */
	PersonJp unmarshal() {
		// 入力XML
		String input = "" //
				+ "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
				+ "<人データ>\n" //
				+ "    <名前>山田 太郎</名前>\n" //
				+ "    <年齢>20</年齢>\n" //
				+ "</人データ>\n" //
				;

		// 実行
		StringReader sr = new StringReader(input);
		PersonJp person = JAXB.unmarshal(sr, PersonJp.class);
		System.out.println(ToStringBuilder.reflectionToString(person));

		return person;
	}

	/**
	 * タグ名に日本語を使うXMLを出力する練習です。
	 * <p>
	 * ・Javaソースファイルの文字コード：UTF-8<br/>
	 * ・XMLの文字コード：Shift_JIS<br/>
	 * </p>
	 */
	String marshalWithEncode() throws IOException, JAXBException {
		// 入力オブジェクト
		PersonJp person = new PersonJp();
		person.name = "山田 太郎";
		person.age = 20;

		// Marshallerインスタンス作成
		// 文字コードにシフトJISを指定。
		// XMLを人が読みやすいようにフォーマットする。
		// ※改行コードはLF（0x0A）のみの模様。
		JAXBContext context = JAXBContext.newInstance(person.getClass());
		Marshaller marshaller = context.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_ENCODING, "Shift_JIS");
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);

		// 実行
		StringWriter sw = new StringWriter();
		marshaller.marshal(person, sw);
		String xml = sw.toString();
		System.out.println(xml);

		return xml;
	}

	/**
	 * タグ名に日本語を使うXMLを読み込む練習です。
	 * <p>
	 * ・ソースの文字コード：UTF-8<br/>
	 * ・XMLの文字コード：Shift_JIS<br/>
	 * </p>
	 */
	PersonJp unmarshalWithEncode() throws IOException {
		// 入力XML
		URL url = getClass().getResource("/com/tryjava/text/xml/person_sjis.xml");
		String input = FileUtils.readFileToString(FileUtils.toFile(url), "Shift_JIS");

		// 実行
		StringReader sr = new StringReader(input);
		PersonJp person = JAXB.unmarshal(sr, PersonJp.class);
		System.out.println(ToStringBuilder.reflectionToString(person));

		return person;
	}
}
