package com.tryjava.ext.javafx;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

/**
 * Java8のJavaFXを使ってみる。
 *
 * ユーザ入力を受け付けてみる。
 *
 * 参考<br>
 * JavaFX - Wikipedia https://ja.wikipedia.org/wiki/JavaFX<br>
 * 初心者のためのJavaFXプログラミング入門 http://libro.tuyano.com/index2?id=8356003<br>
 *
 * @since 2016/6/17
 */
public class JavaFx02 extends Application {

	public static void main(String[] args) {
		launch(args);
	}

	@Override
	public void start(Stage stage) throws Exception {
		String title = this.getClass().getSimpleName();
		Label titleLabel = new Label(title);
		TextField textField = new TextField();

		Label msgLabel = new Label();
		msgLabel.setText("入力結果：");

		Button updateButton = new Button("更新");
		updateButton.setOnAction((actionEvent) -> {
			msgLabel.setText("入力結果：" + textField.getText());
		});

		Button closeButton = new Button("閉じる");
		closeButton.setOnAction((actionEvent) -> {
			stage.hide();
		});

		VBox pane = new VBox();
		pane.setPadding(new Insets(20));
		pane.setSpacing(10);
		pane.getChildren().add(titleLabel);
		pane.getChildren().add(textField);
		pane.getChildren().add(msgLabel);
		pane.getChildren().add(updateButton);
		pane.getChildren().add(closeButton);

		stage.setScene(new Scene(pane));
		stage.setTitle(title);
		stage.show();
	}
}
