package com.tryjava.ext.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/**
 * コマンドラインアプリケーションの実行時引数を解析する練習。
 *
 * Apache Commons CLI について<br>
 * Commons CLI – Home https://commons.apache.org/proper/commons-cli/<br>
 * バージョン1.3以上は、Java5以上が必要。<br>
 * バージョン1.2は、Java4で使用可能。<br>
 */
public class CommonsCli01 {
	public static void main(String[] args) {
		new CommonsCli01().run(args);
	}

	protected void run(String[] args) {
		Options options = new Options();
		options.addOption("h", "help", false, "ヘルプを表示する。");
		options.addOption("a", "aaa", false, "引数なしオプションです。");
		options.addOption("b", "bbb", true, "引数ありオプションです。");

		// パーサー生成
		// Apache Commons CLI 1.2では、BasicParserを使用していたが、
		// 1.3では、DefaultParserを使用する。
		DefaultParser parser = new DefaultParser();

		try {
			CommandLine cl = parser.parse(options, args);

			if (cl.hasOption("h")) {
				HelpFormatter formatter = new HelpFormatter();
				formatter.printHelp("command_name [options] <infile>", options);
			} else {
				System.out.println("オプションa : " + cl.hasOption("a"));
				System.out.println("オプションb : " + cl.getOptionValue("b"));
				System.out.println("必須引数 : " + cl.getArgs()[0]);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}

}
