package com.tryjava.ext.xml;

import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.*;

import javax.xml.bind.JAXBException;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.xml.sax.SAXException;

import com.tryjava.ext.xml.Jaxb02Schema;
import com.tryjava.ext.xml.schema.PersonWithXmlns;

@RunWith(Enclosed.class)
public class Jaxb02SchemaTest {

	public static class XMLスキーマ使用 {
		@Rule
		public TestName testName = new TestName();

		private Jaxb02Schema sut;

		@Before
		public void setUp() throws Exception {
			System.out.println("--- " + testName.getMethodName() + " ---");
			sut = new Jaxb02Schema();
		}

		/**
		 * XMLスキーマを使うXMLを出力する練習です。（スキーマ検証なし）
		 */
		@Test
		public void testMarshal() throws JAXBException, SAXException {
			// 実行
			String actual = sut.marshalPackageInfo();

			// 期待値
			// xmlns属性が付くのがポイント！
			String expected = "" //
					+ "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
					+ "<person xmlns=\"http://www.example.org/person/\">\n" //
					+ "    <name>山田 太郎</name>\n" //
					+ "    <age>20</age>\n" //
					+ "</person>\n" //
					;

			// 検証
			assertThat(actual, is(expected));
		}

		/**
		 * XMLスキーマ使用を使うXMLを読み込む練習です。
		 */
		@Test
		public void testUnmarshal() {
			// 実行
			PersonWithXmlns actual = sut.unmarshalPackageInfo();

			// 検証
			assertThat(actual.name, is("山田 太郎"));
			assertThat(actual.age, is(20));
		}
	}

	public static class XMLスキーマ検証あり {
		@Rule
		public TestName testName = new TestName();

		private Jaxb02Schema sut;

		@Before
		public void setUp() throws Exception {
			System.out.println("--- " + testName.getMethodName() + " ---");
			sut = new Jaxb02Schema();
		}

		/**
		 * XMLスキーマを使うXMLを出力する練習です。（スキーマ検証あり）
		 *
		 * <p>
		 * 上手く出来なくて、次のようなエラーが発生してしまいます。解決方法不明。<br/>
		 * →解決しました。person.xsdに「elementFormDefault="qualified"」を付加することで解決できました。
		 * </p>
		 *
		 * <pre>
		 * javax.xml.bind.MarshalException
		 *  - with linked exception:
		 * [org.xml.sax.SAXParseException; lineNumber: 0; columnNumber: 0; cvc-complex-type.2.4.a: 要素'name'で始まる無効なコンテンツが見つかりました。'{name}'のいずれかが必要です。]
		 * </pre>
		 */
		@Test
		public void testMarshal() throws JAXBException, SAXException {
			// 実行
			String actual = sut.marshalXsd();

			// 期待値
			String expected = "" //
					+ "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" //
					+ "<person xmlns=\"http://www.example.org/person/\">\n" //
					+ "    <name>山田 太郎</name>\n" //
					+ "    <age>20</age>\n" //
					+ "</person>\n" //
					;

			// 検証
			assertThat(actual, is(expected));
		}

		/**
		 * XMLスキーマ使用を使うXMLを読み込む練習です。
		 */
		@Test
		public void testUnmarshal() throws JAXBException, SAXException {
			// 実行
			PersonWithXmlns actual = sut.unmarshalXsd();

			// 検証
			assertThat(actual.name, is("山田 太郎"));
			assertThat(actual.age, is(20));
		}
	}

}
