package com.tryjava.net;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.params.ConnRoutePNames;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.tryjava.AppConfig;
import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Apache HttpComponents HttpClient 4.2）
 *
 * Java5では、Apache HttpComponents HttpClient
 * 4.3以降のバージョンも使用可能であるが、ここでは4.3以前の動作確認をするため、4.2を使用する。
 *
 * プロキシを使ってみる。Basic認証あり。
 *
 * 参考<br>
 * JavaでのHttpClientサンプル - CLOVER
 * http://d.hatena.ne.jp/Kazuhira/20131026/1382796711<br>
 * Apache HttpComponents - HttpClient Quick Start
 * https://hc.apache.org/httpcomponents-client-4.2.x/quickstart.html<br>
 * Java apache HttpClient 4.3からの大幅なインターフェース変更に対応 - Qiita
 * http://qiita.com/mychaelstyle/items/e02b3011d1e71bfa26c5<br>
 * javaのHttpClientでファイルをダウンロード(proxy経由とBASIC認証付き) | ぱーくん plus idea
 * http://web.plus-idea.net/2012/04/java-httpclient-proxy-basic/<br>
 *
 * @since 2016/5/26
 */
public class ApacheHttpClient02Proxy {
	private static final String PROXY_HOST = AppConfig.getString("proxy.host");
	private static final int PROXY_PORT = AppConfig.getInt("proxy.port");
	private static final String PROXY_USER = AppConfig.getString("proxy.user");
	private static final String PROXY_PASSWORD = AppConfig.getString("proxy.password");

	public void run() {
		doGet();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		try {
			// クライアント作成
			DefaultHttpClient client = new DefaultHttpClient();
			// プロキシ設定
			HttpHost proxy = new HttpHost(PROXY_HOST, PROXY_PORT);
			client.getParams().setParameter(ConnRoutePNames.DEFAULT_PROXY, proxy);
			client.getCredentialsProvider().setCredentials( //
					new AuthScope(proxy), //
					new UsernamePasswordCredentials(PROXY_USER, PROXY_PASSWORD));

			// リクエスト作成
			HttpGet request = new HttpGet("http://www.google.co.jp/");

			try {
				// 接続
				HttpResponse response = client.execute(request);

				// レスポンスコード取得
				StatusLine statusLine = response.getStatusLine();
				System.out.println(statusLine);
				if (statusLine.getStatusCode() != HttpStatus.SC_OK) {
					throw new RuntimeException("エラーレスポンスを受信しました。statusLine=" + statusLine);
				}

				// レスポンスボディ取得
				HttpEntity entity = response.getEntity();
				String content = EntityUtils.toString(entity);
				System.out.println(content);
			} finally {
				request.releaseConnection();
			}

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}
}
