package com.tryjava.util;

import java.io.UnsupportedEncodingException;

import org.apache.commons.codec.binary.Base64;

/**
 * Apache CommonsのBase64を使ってみる。
 */
public class Base64Apache {

	public static void main(String[] args) {
		new Base64Apache().run();
	}

	public void run() {
		step01();
	}

	private void step01() {
		try {
			byte[] encoded = Base64.encodeBase64("こんにちは".getBytes("UTF-8"));
			System.out.println(new String(encoded));

			byte[] decoded = Base64.decodeBase64(encoded);
			System.out.println(new String(decoded, "UTF-8"));

		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
}
