package com.tryjava.net;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Java標準APIのみ）
 *
 * 色々な操作を試してみる。
 *
 * 参考<br>
 * JavaでのHttpClientサンプル - CLOVER<br>
 * http://d.hatena.ne.jp/Kazuhira/20131026/1382796711<br>
 *
 * @since 2016/5/26
 */
public class JavaHttpClient02 {

	public void run() {
		doGet();
		doPost();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		HttpURLConnection con = null;
		try {
			// リクエスト作成
			// TODO 日本語が文字化けする
			URL url = new URL("http://localhost:8080/tryjava-dummy-web/echo" //
					+ "?param1=value1" //
					+ "&UrlEncode=" + URLEncoder.encode("+-/_", "UTF-8") //
					+ "&text=" + URLEncoder.encode("日本語", "UTF-8"));

			con = (HttpURLConnection) url.openConnection();
			con.setRequestMethod("GET");
			// リダイレクト許可
			con.setInstanceFollowRedirects(true);
			// キャッシュ設定
			con.setUseCaches(true);
			// ヘッダー設定
			con.setRequestProperty("Accept-Language", "ja");
			con.setRequestProperty("X-Header1", "value1");
			// ※Java1.4ではタイムアウト設定なし

			// 接続
			con.connect();

			// レスポンスコード取得
			int statusCode = con.getResponseCode();
			System.out.println(statusCode + " " + con.getResponseMessage());
			if (statusCode != HttpURLConnection.HTTP_OK) {
				throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
			}

			// レスポンスヘッダ取得
			Set set = con.getHeaderFields().entrySet();
			Iterator ite = set.iterator();
			while (ite.hasNext()) {
				Entry entry = (Entry) ite.next();
				String key = (String) entry.getKey();
				List values = (List) entry.getValue();
				System.out.println(key + ": " + ToStringBuilder.reflectionToString(values, ToStringStyle.SIMPLE_STYLE));
			}

			// レスポンスボディ取得
			System.out.println(con.getContentType());
			InputStream is = con.getInputStream();
			String encoding = getEncoding(con);
			String content = IOUtils.toString(is, encoding);
			System.out.println(content);

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		} finally {
			if (con != null) {
				con.disconnect();
			}
		}
	}

	void doPost() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		HttpURLConnection con = null;
		try {
			// リクエスト作成
			URL url = new URL("http://localhost:8080/tryjava-dummy-web/echo");
			con = (HttpURLConnection) url.openConnection();
			con.setRequestMethod("POST");
			con.setDoOutput(true);
			// POSTパラメータ
			BufferedWriter w = new BufferedWriter(new OutputStreamWriter(con.getOutputStream(), "UTF-8"));
			w.write("param1=value1");
			w.write("&UrlEncode=" + URLEncoder.encode("+-/_", "UTF-8"));
			w.write("&text=" + URLEncoder.encode("日本語", "UTF-8"));
			w.flush();

			// レスポンスコード取得
			int statusCode = con.getResponseCode();
			System.out.println(statusCode + " " + con.getResponseMessage());
			if (statusCode != HttpURLConnection.HTTP_OK) {
				throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
			}

			// レスポンスヘッダ取得
			Set set = con.getHeaderFields().entrySet();
			Iterator ite = set.iterator();
			while (ite.hasNext()) {
				Entry entry = (Entry) ite.next();
				String key = (String) entry.getKey();
				List values = (List) entry.getValue();
				System.out.println(key + ": " + ToStringBuilder.reflectionToString(values, ToStringStyle.SIMPLE_STYLE));
			}

			// レスポンスボディ取得
			System.out.println(con.getContentType());
			InputStream is = con.getInputStream();
			String encoding = getEncoding(con);
			String content = IOUtils.toString(is, encoding);
			System.out.println(content);

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		} finally {
			if (con != null) {
				con.disconnect();
			}
		}
	}

	/**
	 * 簡易的な文字コード判定処理
	 */
	String getEncoding(HttpURLConnection con) {
		String encoding = null;
		Matcher matcher = Pattern.compile("charset=(.*)", Pattern.CASE_INSENSITIVE).matcher(con.getContentType());
		if (matcher.find()) {
			encoding = matcher.group(1);
		}
		System.out.println("encoding=" + encoding);
		return encoding;
	}
}
