package com.tryjava.io.file;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

/**
 * テキストファイル読み書きの練習
 *
 * 参考
 * <ul>
 * <li>Javaで1行ずつテキストデータを読み込むイディオムの変遷 - argius note<br>
 * http://argius.hatenablog.jp/entry/2015/06/06/234315
 * </ul>
 *
 * @sine 2016/5/2
 */
public class TextFile01 {
	static final String path = "./work/file01.txt";

	public static void main(String[] args) {
		TextFile01 app = new TextFile01();
		app.run();
	}

	void run() {
		writeLines();
		readLines();
	}

	/**
	 * Java1.4でのテキストファイル書き込み（順次）
	 */
	void writeLines() {
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(path), "UTF-8"));
			pw.println("Hello World");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} finally {
			if (pw != null) {
				pw.close();
			}
		}
	}

	/**
	 * Java1.4でのテキストファイル読み込み（順次）
	 */
	void readLines() {
		BufferedReader br = null;
		try {
			br = new BufferedReader(new InputStreamReader(new FileInputStream(path), "UTF-8"));
			String line;
			while ((line = br.readLine()) != null) {
				System.out.println(line);
			}
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (br != null) {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}
}
