package com.tryjava.dummyweb.echo;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Servlet implementation class EchoServlet
 */
public class EchoServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(EchoServlet.class);

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public EchoServlet() {
		super();
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		logger.trace("START");
		exec(request, response);
		logger.trace("END");
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		logger.trace("START");
		exec(request, response);
		logger.trace("END");
	}

	@Override
	protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		logger.trace("START");
		exec(req, resp);
		logger.trace("END");
	}

	@Override
	protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		logger.trace("START");
		exec(req, resp);
		logger.trace("END");
	}

	protected void exec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		request.setCharacterEncoding("UTF-8");

		response.setContentType("text/html;charset=UTF-8");
		response.addHeader("Cache-Control", "no-store, no-cache");
		response.addHeader("Pragma", "no-cache");

		PrintWriter pw = response.getWriter();
		pw.println("<html>");
		pw.println("<head>");
		pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
		pw.println("<title>Echo</title>");
		pw.println("</head>");
		pw.println("<body>");
		pw.println("<h1>Echoページ</h1>");

		pw.println("<p>メソッド<br>" + request.getMethod() + "</p>");
		pw.println("<p>リクエストURL<br>" + request.getRequestURL().toString() + "</p>");
		// pw.println("<p>リクエストURI<br>" + request.getRequestURI() + "</p>");
		// pw.println("<p>コンテキストパス<br>" + request.getContextPath() + "</p>");
		pw.println("<p>クエリー文字列<br>" + request.getQueryString() + "</p>");

		pw.println(getParamsHtml(request));
		pw.println(getHeaderHtml(request));
		pw.println(getContent(request));

		pw.println("</body>");
		pw.println("</html>");
	}

	private String getParamsHtml(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<p>");
		sb.append("パラメータ<br>");
		Enumeration<String> names = request.getParameterNames();
		while (names.hasMoreElements()) {
			String name = names.nextElement();
			String[] values = request.getParameterValues(name);
			sb.append(name + "=" + ToStringBuilder.reflectionToString(values, ToStringStyle.SIMPLE_STYLE) + "<br>");
		}
		sb.append("</p>");

		return sb.toString();
	}

	private String getHeaderHtml(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<p>ヘッダー<br>");
		Enumeration<String> names = request.getHeaderNames();
		while (names.hasMoreElements()) {
			String name = names.nextElement();
			Enumeration<String> values = request.getHeaders(name);
			while (values.hasMoreElements()) {
				String value = values.nextElement();
				sb.append(name + ": " + value + "<br>");
			}
		}
		sb.append("</p>");

		return sb.toString();
	}

	private String getContent(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		try {
			sb.append("<p>コンテンツボディ<br>");
			InputStream is = request.getInputStream();
			sb.append(IOUtils.toString(is, "UTF-8") + "<br>");
			sb.append("</p>");
		} catch (IOException e) {
			throw new RuntimeException(e);
		}

		return sb.toString();
	}
}
