package org.pulpdust.snappingcamera;

import java.io.File;
import java.util.List;

import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.MimeTypeMap;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import android.view.MenuItem;
//import android.support.v4.app.NavUtils;

public class MainActivity extends Activity {
//	SnappingCameraView snpcmrvw;
	final static String TAG = "Snapping Camera Main";
	final static String mprf = "MainActivity";
	private Uri imguri;
	private Uri lastimguri;
	Button button1;
	Button button2;
	EditText edttxt1;
	String subject;
	String[] send_to = new String[1];
	String[] cc = new String[1];
	String[] bcc = new String[1];
	boolean dlt = false;
	File objct;

    @Override
    public void onCreate(Bundle savedInstanceState) {
    	readPrefs();
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
//        snpcmrvw = (SnappingCameraView) findViewById(R.id.surfaceView1);
        if (Intent.ACTION_SEND.equals(getIntent().getAction())){
        	Intent throwint = buildSender(0);
        	String type = getIntent().getType();
        	throwint.setType(type);
        	Uri uri = getIntent().getParcelableExtra(Intent.EXTRA_STREAM);
        	throwint.putExtra(Intent.EXTRA_STREAM, uri);
			try {
				startActivity(throwint);
			} catch (ActivityNotFoundException e){
	        	Toast.makeText(this, R.string.err_not_mail, Toast.LENGTH_LONG).show();
				Log.e(TAG, e.getMessage());
			}
			finish();
        } else {
        	button1 = (Button) findViewById(R.id.button1);
        	button1.setOnClickListener(new OnClickListener(){
        		public void onClick(View v){
        			startCamera();        		
        		}
        	});
        	button2 = (Button) findViewById(R.id.button2);
        	if (isIntentAvailable(this, "org.pulpdust.kigo.action.PICK_KEYWORD")){
        		button2.setVisibility(View.VISIBLE);
        		button2.setOnClickListener(new OnClickListener(){
					@Override
					public void onClick(View v) {
						Intent intent = new Intent("org.pulpdust.kigo.action.PICK_KEYWORD");
//						if (subject != null){
//							intent.putExtra("org.pulpdust.kigo.extra.WORD", subject);
//						}
				        try {
				            startActivityForResult(intent, 4);
				        } catch (ActivityNotFoundException e){
				        	Toast.makeText(getApplicationContext(), R.string.err_not_act, Toast.LENGTH_LONG).show();
							Log.e(TAG, e.getMessage());
				        }
					}
        		});
        	} else {
        		button2.setVisibility(View.GONE);
        	}
        	edttxt1 = (EditText) findViewById(R.id.editText1);
        	if (subject != null){
        		edttxt1.setText(subject);
        	}
        	edttxt1.addTextChangedListener(new TextWatcher(){

				@Override
				public void afterTextChanged(Editable arg0) {
					subject = edttxt1.getText().toString();
				}

				@Override
				public void beforeTextChanged(CharSequence s, int start,
						int count, int after) {
				}

				@Override
				public void onTextChanged(CharSequence s, int start,
						int before, int count) {
				}
        		
        	});
        }
    }
    @Override
    public void onStop(){
    	super.onStop();
    	Log.d(TAG, "onStop");
    	writeMainprefs();
    }
    public void writeMainprefs(){
    	SharedPreferences mprefs = getSharedPreferences(mprf, 0);
    	SharedPreferences.Editor sedit = mprefs.edit();
    	sedit.putString("subject", subject);
    	if (imguri != null){
    		sedit.putString("lastimguri", imguri.toString());
    	}
    	sedit.commit();
    }
    @Override
    public void onDestroy(){
    	super.onDestroy();
    	Log.d(TAG, "onDestroy");
    }
//    @Override
//    public boolean dispatchKeyEvent(KeyEvent kev){
//    	if (kev.getAction() == KeyEvent.ACTION_DOWN){
//    		switch (kev.getKeyCode()){
//    		case KeyEvent.KEYCODE_BACK:
//    	    	if (dlt){
//    	        	if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())){
//    	        		File file = new File(Environment.getExternalStorageDirectory(), "/Pictures/snapping");
//    	        		final Uri uri = Uri.fromFile(file);
//    	        		new Thread(new Runnable(){
//    	        			@Override
//    	        			public void run(){
//    	    	        		delDel(uri);
//    	        			}
//    	        		}).start();
//    	        	}
//    	    	}
//    		}
//    		return super.dispatchKeyEvent(kev);
//    	} else {
//    		return super.dispatchKeyEvent(kev);
//    	}
//
//    }
    public void delDel(Uri path){
    	String path_s = path.toString();
    	if (path_s.startsWith("file://")){
    		path_s = path_s.substring(7);
    	}
    	File dir = new File(path_s);
    	String files[] = dir.list();
    	if (files == null){
    		
    	} else {
    		for(int index = 0 ; index < files.length; index++){
    			File who = new File(dir, files[index]);
    			if (who.isDirectory()){
    				
    			} else {
        			if (who.exists() && who.canWrite()){
    					who.delete();
    			}

    			}
    		}
    	}
    }
    public void startCamera(){
    	if (!Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())){
    		Toast.makeText(this, R.string.err_not_sd, Toast.LENGTH_LONG).show();
    		return;
    	}
//        File path = 
//        		Environment.getExternalStoragePublicDirectory(
//        				Environment.DIRECTORY_PICTURES + "/snapping");
        File path = new File(Environment.getExternalStorageDirectory(), "/Pictures/snapping");
        if (!path.exists()){
        	path.mkdirs();
        }
        if (!path.exists()){
    		Toast.makeText(this, R.string.err_den_sd, Toast.LENGTH_LONG).show();
    		return;
        }
        String fname = System.currentTimeMillis() + ".jpg";
        objct = new File(path, fname);
        ContentValues cvals = new ContentValues();
        cvals.put(MediaStore.Images.Media.TITLE, fname);
        cvals.put(MediaStore.Images.Media.MIME_TYPE, "image/jpg");
//        imguri = getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cvals);
        imguri = Uri.fromFile(objct);
        
        Intent intent = new Intent();
        intent.setAction(MediaStore.ACTION_IMAGE_CAPTURE);
//        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(MediaStore.EXTRA_OUTPUT, imguri);
        writeMainprefs();
        try {
            startActivityForResult(intent, 1);        	
        } catch (ActivityNotFoundException e){
        	Toast.makeText(this, R.string.err_not_cam, Toast.LENGTH_LONG).show();
			Log.e(TAG, e.getMessage());
        }
    }
    
    public Intent buildSender(int mode){
    	Intent intent = new Intent();
    	if (mode == 1){
    		intent.setAction(Intent.ACTION_SENDTO);
    	} else if (mode == 0){
    		intent.setAction(Intent.ACTION_SEND);
    	} else {
    		intent.setAction(Intent.ACTION_SEND);
    	}
    	intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    	if (!subject.equalsIgnoreCase("")){
	    intent.putExtra(Intent.EXTRA_SUBJECT, subject);
    	}
    	if (!send_to[0].equalsIgnoreCase("")){
    		if (mode == 1){
    			intent.setData(Uri.parse("mailto:" + send_to[0]));
    		} else {
    			intent.putExtra(Intent.EXTRA_EMAIL, send_to);
    		}
    	} else {
    		if (mode == 1){
    			intent.setData(Uri.parse("mailto:"));
    		}
    	}
    	if (!cc[0].equalsIgnoreCase("")){
	    intent.putExtra(Intent.EXTRA_CC, cc);
    	}
    	if (!bcc[0].equalsIgnoreCase("")){
    	intent.putExtra(Intent.EXTRA_BCC, bcc);
    	}
    	return intent;
    }
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data){
    	switch (requestCode){
    	case 1:
			if (imguri == null){
				imguri = lastimguri;
			}
    		if (resultCode == RESULT_OK){
    			Uri sendfile = null;
    			if (data != null){
    				sendfile = data.getData();
    			}
    			if (sendfile != null){
    				sendfile = data.getData();
    			} else {
    				sendfile = imguri;
    			}
    			Intent mailint = buildSender(0);
    			mailint.setType("image/jpg");
    			mailint.putExtra(Intent.EXTRA_STREAM, sendfile);
    			mailint.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
    			try {
    				startActivity(mailint);
    			} catch (ActivityNotFoundException e){
    	        	Toast.makeText(this, R.string.err_not_mail, Toast.LENGTH_LONG).show();
    				Log.e(TAG, e.getMessage());
    			}
    		} else {
//    			Toast.makeText(this, R.string.err_not_mail, Toast.LENGTH_LONG).show();
    			File fl = new File(imguri.toString());
    			try {
    			if (fl.exists() && fl.isFile() && fl.canWrite()){
    				if (fl.length() == 0){
    					fl.delete();
    				}
    			}
    			} catch (SecurityException e){
    				Log.e(TAG, e.getMessage());
    			}
    		}
    		break;
    	case 2:
    		readPrefs();
    		break;
    	case 3:
    		if (resultCode == RESULT_OK){
    			String suri = data.getDataString();
    			File file = new File(suri);
    			if (!file.isDirectory()){
    				Intent mailint = buildSender(0);
    				String ext = MimeTypeMap.getFileExtensionFromUrl(suri);
    				String mime = null;
    				if (ext != null){
    					mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext.toLowerCase());
    				} else {
    					mime = "application/octet-stream";
    				}
    				if (mime != null){
    					mailint.setType(mime);
    				} else {
    					mailint.setType("application/octet-stream");
    				}
    				mailint.putExtra(Intent.EXTRA_STREAM, Uri.parse(suri));
        			try {
        				startActivity(mailint);
        			} catch (ActivityNotFoundException e){
        	        	Toast.makeText(this, R.string.err_not_mail, Toast.LENGTH_LONG).show();
        				Log.e(TAG, e.getMessage());
        			}
    			} else {
    				Toast.makeText(this, R.string.err_not_file, Toast.LENGTH_LONG).show();
    			}
    		}
    		break;
    	case 4:
    		if (resultCode == RESULT_OK){
    			subject = data.getStringExtra("WORD");
    			edttxt1.setText(subject);
    		}
    	}
    }
    public void readPrefs(){
    	SharedPreferences sprefs = PreferenceManager.getDefaultSharedPreferences(this);
//    	subject = sprefs.getString("subject", "");
    	send_to[0] = sprefs.getString("send_to", "");
    	cc[0] = sprefs.getString("cc", "");
    	bcc[0] = sprefs.getString("bcc", "");
    	dlt = sprefs.getBoolean("do_delete", false);
    	SharedPreferences mprefs = getSharedPreferences(mprf, 0);
    	subject = mprefs.getString("subject", "");
    	lastimguri = Uri.parse(mprefs.getString("lastimguri", ""));
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        final boolean scanAvailable = isIntentAvailable(this,
            "org.openintents.action.PICK_FILE");

        MenuItem item;
        item = menu.findItem(R.id.menu_open);
        item.setEnabled(scanAvailable);

        return super.onPrepareOptionsMenu(menu);
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item){
    	switch (item.getItemId()){
    	case R.id.menu_settings:
    		Intent prefint = new Intent();
    		prefint.setClassName("org.pulpdust.snappingcamera",
    				"org.pulpdust.snappingcamera.SnappingCameraPrefs");
    		startActivityForResult(prefint, 2);
    		return true;
    	case R.id.menu_notake:
    		Intent ntint = buildSender(1);
			try {
				startActivity(ntint);
			} catch (ActivityNotFoundException e){
	        	Toast.makeText(this, R.string.err_not_mail, Toast.LENGTH_LONG).show();
				Log.e(TAG, e.getMessage());
			}
			return true;
    	case R.id.menu_open:
    		Intent fileint = new Intent("org.openintents.action.PICK_FILE");
    		fileint.putExtra("org.openintents.extra.TITLE",
        			getString(R.string.menu_open) + " - " + getString(R.string.app_name));
    		try {
    			startActivityForResult(fileint, 3);
    		} catch (ActivityNotFoundException e){
    			Toast.makeText(this, R.string.err_not_act, Toast.LENGTH_LONG).show();
				Log.e(TAG, e.getMessage());
    		}
    		return true;
    	case R.id.menu_close:
	    	if (dlt){
	        	if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())){
	        		File file = new File(Environment.getExternalStorageDirectory(), "/Pictures/snapping");
	        		final Uri uri = Uri.fromFile(file);
	        		new Thread(new Runnable(){
	        			@Override
	        			public void run(){
	    	        		delDel(uri);
	        			}
	        		}).start();
	        	}
	    	}
	    	finish();
    		return true;
    	default:
    		return super.onOptionsItemSelected(item);
    	}
    }
    
    public static boolean isIntentAvailable(Context context, String action) {
        final PackageManager packageManager = context.getPackageManager();
        final Intent intent = new Intent(action);
        List<ResolveInfo> list =
                packageManager.queryIntentActivities(intent,
                        PackageManager.MATCH_DEFAULT_ONLY);
        return list.size() > 0;
    }

    
}
