package org.pulpdust.kigo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.net.URLEncoder;
import java.lang.Thread;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.xmlpull.v1.XmlPullParser;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.text.ClipboardManager;
import android.util.Log;
import android.util.Xml;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.View.OnKeyListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView.OnEditorActionListener;
import android.widget.Toast;
import android.widget.TextView;
import android.view.View.OnClickListener;
import android.view.inputmethod.EditorInfo;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;

public class KigoActivity extends FragmentActivity {
	static final String TAG = "KigoActivity";
	static List<String> lst = new ArrayList<String>();
	static ArrayAdapter<String> arryadpt;
	EditText edttxt;
	Button bttn;
	ListView lstvw;
	static HttpResponse res = null;
	CharSequence cptxt;
	static String host = "http://h.hatena.ne.jp/";
	String base = host + "keyword/";
	String kpth = "keyword/";
	String uri = host + 
			"api/keywords/list.xml?without_related_keywords=true";
	String lpth = "api/keywords/list.xml?without_related_keywords=true";
	String iuri = host + "api/keywords/show.xml?word=";
	static String ipth = "api/keywords/show.xml?word=";
	String guri;
	String sbj = "";
	String obj;
	String bwrd = "";
	String buri;
	String gactn = "org.pulpdust.kigo.action.PICK_KEYWORD";
	String gactn2 = "org.pulpdust.kigo.action.PICK_RELATED";
	String gextr = "org.pulpdust.kigo.extra.WORD";
	String[] send_to = new String[1];
	String[] cc = new String[1];
	String[] bcc = new String[1];
	String svdt = "savedata";
	int tpbhvr;
	int fntsz = 12;
	boolean prvd;
	boolean rltd;
	

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (gactn.equals(getIntent().getAction())){
        	prvd = true;
        	rltd = false;
        	sbj = getIntent().getStringExtra(gextr);
        } else if (gactn2.equals(getIntent().getAction())){
        	prvd = false;
        	rltd = true;
        	sbj = getIntent().getStringExtra(gextr);
        } else {
        	prvd = false;
        	rltd = false;
        	loadSave();
        }
        readPrefs();
//        requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_kigo);
        edttxt = (EditText) findViewById(R.id.editText1);
        if (rltd == true){
        	edttxt.setVisibility(View.GONE);
        } else {
        	if (sbj != null){
        		edttxt.setText(sbj);
        	} else {
        		sbj = "";
        	}
        	edttxt.setOnEditorActionListener(new OnEditorActionListener(){
        		@Override
        		public boolean onEditorAction(TextView v, int aid, KeyEvent kev) {
        			if (aid == EditorInfo.IME_ACTION_SEARCH){
        				goFind();
        			}
        			return true;
        		}
        	
        	});
        	edttxt.setOnKeyListener(new OnKeyListener(){
        		@Override
        		public boolean onKey(View v, int kcd, KeyEvent kev) {
        			if (kev.getAction() == KeyEvent.ACTION_UP &&
        					kcd == KeyEvent.KEYCODE_ENTER){
        				goFind();
        				return true;
        			}
        			return false;
        		}
        	});
        }
        bttn = (Button) findViewById(R.id.button1);
        if (rltd == true){
        	bttn.setVisibility(View.GONE);
        } else {
        	bttn.setOnClickListener(new OnClickListener(){
        		public void onClick(View v){
        			goFind();
        		}
        	});
        }
        lstvw = (ListView) findViewById(R.id.listView1);
        registerForContextMenu(lstvw);
        lstvw.setOnItemClickListener(new OnItemClickListener(){
			@Override
			public void onItemClick(AdapterView<?> av, View v, int pos,
					long id) {
				if (prvd){
					Intent intent = new Intent();
					intent.putExtra("WORD", ((TextView) v).getText());
					setResult(RESULT_OK, intent);
					finish();
				} else {
					if (tpbhvr == 0){
						doCopy(((TextView) v).getText());
					} else if (tpbhvr == 1){
						sendTo(((TextView) v).getText());
					} else if (tpbhvr == 2){
						doOpen(((TextView) v).getText());
					}
				}
			}
        });
        lstvw.setOnItemLongClickListener(new OnItemLongClickListener(){
			@Override
			public boolean onItemLongClick(AdapterView<?> av, View v,
					int pos, long id) {
				cptxt = ((TextView) v).getText();
				openContextMenu(lstvw);
				return true;
			}
        });
        arryadpt = new ArrayAdapter<String>(this, R.layout.list_item, lst){
        	@Override
        	public View getView(int pos, View v, ViewGroup vg){
        		TextView tview = (TextView) super.getView(pos, v, vg);
        		tview.setTextSize(fntsz);
        		return tview;
        	}
        };
        lstvw.setAdapter(arryadpt);
//    	final String save[] = (String[]) getLastNonConfigurationInstance();
    	final String save[] = (String[]) getLastCustomNonConfigurationInstance();
    	if (save != null){
    		if (save[0] != null){
    		obj = save[0];
    		arryadpt.clear();
      		xmlBaker(obj);
    		}
    		if (save[1] != null){ buri = save[1]; }
    		if (save[2] != null){ bwrd = save[2]; }
      	} else if (isConnect(this)){
          	{
      		if (rltd == true){
      			guri = host + ipth + sbj;
          		reLoad(guri);
      		} else {
//      			guri = host + lpth + "&word=" + sbj;
      			goFind();
      		}
      	}
      	} else {
          	Toast.makeText(this, R.string.err_no_net, 
        			Toast.LENGTH_SHORT).show();
      	}
    }
    public void goFind(){
		sbj = edttxt.getText().toString().trim();
		try {
			guri = host + lpth + "&word=" + URLEncoder.encode(sbj, "UTF-8").replace("+", "%20");
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		reLoad(guri);					
    }
    public void doCopy(CharSequence text){
		ClipboardManager clipbd = (ClipboardManager)
				getSystemService(Context.CLIPBOARD_SERVICE);
		clipbd.setText(text);
		Toast.makeText(getApplicationContext(), getString(R.string.menu_copy) + ":" + text,
				Toast.LENGTH_SHORT).show();
    }
    @Override
    public void onCreateContextMenu(ContextMenu cm, View v,
    		ContextMenuInfo cmi){
    	super.onCreateContextMenu(cm, v, cmi);
    	cm.setHeaderTitle(cptxt);
    	MenuInflater minflater = getMenuInflater();
    	minflater.inflate(R.menu.main_context, cm);
    }
    public void sendTo(CharSequence subject){
		Uri suri = Uri.parse("mailto:");
		if (!send_to[0].equals("")){
			suri = Uri.parse("mailto:" + send_to[0]);
		}
		
		Intent intent = new Intent(Intent.ACTION_SENDTO, suri);
    	if (!cc[0].equals("")){
    	    intent.putExtra(Intent.EXTRA_CC, cc);
        }
       if (!bcc[0].equals("")){
        	intent.putExtra(Intent.EXTRA_BCC, bcc);
        }
		intent.putExtra(Intent.EXTRA_SUBJECT, subject);
		startActivity(intent);
    }
    public void doOpen(CharSequence word){
		String openuri;
		try {
			openuri = host + kpth + URLEncoder.encode(word.toString(), "UTF-8").replace("+", "%20");
    		Intent openi = new Intent(Intent.ACTION_VIEW, Uri.parse(openuri));
    		startActivity(openi);
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    @Override
    public boolean onContextItemSelected(MenuItem mi){
    	switch (mi.getItemId()){
    	case R.id.menu_copy:
    		doCopy(cptxt);
    		return true;
    	case R.id.menu_send:
    		sendTo(cptxt);
    		return true;
    	case R.id.menu_open:
    		doOpen(cptxt);
    		return true;
    	case R.id.menu_info:
    		DialogFragment id = InfoDialog.newInstance(this, cptxt.toString());
    		id.show(getSupportFragmentManager(), "hoge");
//    		echoInfo(cptxt.toString());
    		return true;
    	case R.id.menu_relat:
//    		Intent intent = new Intent(gactn2);
//    		intent.setClassName("org.pulpdust.kigo", "org.pulpdust.kigo.KigoActivity");
//    		intent.putExtra(gextr, cptxt);
//    		intent.removeCategory(Intent.CATEGORY_DEFAULT);
//    		intent.addCategory(Intent.CATEGORY_LAUNCHER);
//    		intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK|Intent.FLAG_ACTIVITY_MULTIPLE_TASK);
//    		try {
//    			startActivity(intent);
//    			return true;
//    		} catch (ActivityNotFoundException e){
//    			Log.e(TAG, e.getMessage());
//    			return false;
//    		}
    		try {
    			if (!rltd){
        			bwrd = sbj;
        			buri = guri;
        			rltd = true;
    			}
				guri = host + ipth + URLEncoder.encode(cptxt.toString(), "UTF-8").replace("+", "%20");
				edttxt.setVisibility(View.GONE);
				bttn.setVisibility(View.GONE);
				setTitle(getString(R.string.app_name) + " - " + getString(R.string.relateds));
				reLoad(guri);
				return true;
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return false;
			}
    	default:
    		return false;
    	}
    }
    public static class InfoDialog extends DialogFragment{
    	static Context cx;
    	public static InfoDialog newInstance(Context c, String w){
    		InfoDialog id = new InfoDialog();
    		cx = c;
    		Bundle args = new Bundle();
    		args.putString("word", w);
    		id.setArguments(args);
    		return id;
    	}
    	@Override
    	public Dialog onCreateDialog(Bundle savedInstanceState){
    		return echoInfo(cx, getActivity(), getArguments().getString("word"));
    	}
    }
    public static class Share {
    	static String xml;
    }
    public static AlertDialog echoInfo(final Context context, final FragmentActivity av, final String word){
//    	final Handler handler = new Handler();
    	boolean isc = isConnect(context);
    	AlertDialog ad = null;
    	Share.xml = null;
//		final Context context = this;
    	Thread th = new Thread(new Runnable(){
    		@Override
    		public void run(){
		    	try {
		    		String turi = host + ipth + URLEncoder.encode(word, "UTF-8").replace("+", "%20");
			    	Share.xml = getHttp(context, turi);

				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
    		}
    	});
    	if (isc){
    		th.start();
    		try {
    			th.join();
    		} catch (InterruptedException e) {
    			// TODO Auto-generated catch block
    			e.printStackTrace();
    		}
//		handler.post(new Runnable(){
//			@Override
//			public void run(){
			    	if (Share.xml != null){
			    		String info[] = exInfo(Share.xml);
			    		if(info != null){
				    		AlertDialog.Builder abuilder = new AlertDialog.Builder(context);
				    		LayoutInflater linflater = 
				    				(LayoutInflater) context.getSystemService(LAYOUT_INFLATER_SERVICE);
				    		View layout = linflater.inflate(R.layout.info,
				    				(ViewGroup) av.findViewById(R.id.layout_root));
				    		TextView tv1 = (TextView) layout.findViewById(R.id.textView1);
				    		TextView tv2 = (TextView) layout.findViewById(R.id.textView2);
				    		TextView tv3 = (TextView) layout.findViewById(R.id.textView3);
//				    		TextView tv4 = (TextView) layout.findViewById(R.id.textView4);
				    		tv1.setText(av.getString(R.string.info_entries) + info[0]);
				    		tv2.setText(av.getString(R.string.info_follows) + info[1]);
				    		tv3.setText(av.getString(R.string.info_title) + info[2]);
//				    		tv4.setText(getString(R.string.info_word) + info[3]);
			    			abuilder.setTitle(word);
			    			abuilder.setCancelable(true);
			    			abuilder.setView(layout);
			    			ad = abuilder.create();
			    		}
			    	}
    	}
			    	if (ad == null) {
			    		AlertDialog.Builder empty = new AlertDialog.Builder(context);
			    		LayoutInflater linflater = 
			    				(LayoutInflater) context.getSystemService(LAYOUT_INFLATER_SERVICE);
			    		View layout = linflater.inflate(R.layout.info,
			    				(ViewGroup) av.findViewById(R.id.layout_root));
			    		TextView tv1 = (TextView) layout.findViewById(R.id.textView1);
			    		tv1.setText(R.string.err_fail_get);
		    			empty.setTitle(word);
		    			empty.setCancelable(true);
		    			empty.setView(layout);
			    		ad = empty.create();
//			    		Toast.makeText(context, R.string.err_fail_get, 
//		              			Toast.LENGTH_SHORT).show();
			    	}
//			}
//		});
		return ad;
    }
    
//    @Override
//    public Object onRetainNonConfigurationInstance(){
//    	final String save[] = new String[3];
//    	save[0] = obj;
//    	save[1] = buri;
//    	save[2] = bwrd;
//    	return save;
//    }
    public Object onRetainCustomNonConfiguratonInstance(){
    	final String save[] = new String[3];
    	save[0] = obj;
    	save[1] = buri;
    	save[2] = bwrd;
    	return save;
    }
    @Override
    public boolean dispatchKeyEvent(KeyEvent kev){
    	if (kev.getAction() == KeyEvent.ACTION_DOWN){
    		switch (kev.getKeyCode()){
    		case KeyEvent.KEYCODE_BACK:
    			if (rltd){
    				guri = buri;
    				sbj = bwrd;
    				buri = null;
    				bwrd = "";
    				edttxt.setVisibility(View.VISIBLE);
    				bttn.setVisibility(View.VISIBLE);
    				rltd = false;
    				setTitle(R.string.app_name);
    				reLoad(guri);
    				return true;
    			} else if (!sbj.equals("")){
    				edttxt.setText("");
    				goFind();
    				return true;
    			} else {
    				return super.dispatchKeyEvent(kev);
    			}
    		default:
    			return super.dispatchKeyEvent(kev);
    		}
    	} else {
    		return super.dispatchKeyEvent(kev);
    	}
    }
    public void reLoad(final String uri){
//    	final Getter getter = new Getter();
    	final Handler handler = new Handler();
    	final Context c = getApplicationContext();
    	new Thread(new Runnable(){
    		@Override
    		public void run(){
	        	  obj = null;
//	        	  obj = getter.getHttp(uri);
	        	  obj = getHttp(c, uri);
    			handler.post(new Runnable(){
    				@Override
    				public void run(){
      	        	  arryadpt.clear();
      	        	  if (obj != null){
      	        		  xmlBaker(obj);
      	        	  } else {
      	        		  Toast.makeText(getApplicationContext(), R.string.err_fail_get, 
      	              			Toast.LENGTH_SHORT).show();
      	        	  }
    					
    				}
    			});
    			
    		}
    	}).start();
    }
    public static boolean isConnect(Context c){
    	ConnectivityManager cmanager = (ConnectivityManager)
    			c.getSystemService(Context.CONNECTIVITY_SERVICE);
    	NetworkInfo ninfo = cmanager.getActiveNetworkInfo();
    	if (ninfo != null){
    		return cmanager.getActiveNetworkInfo().isConnected();
    	}
    	return false;
    }
    public static String getHttp(Context context, final String uri){
    	if (!isConnect(context)){
          	Toast.makeText(context, R.string.err_no_net, 
            			Toast.LENGTH_SHORT).show();
          	return null;
       } else {
    	   try {
				    	    	HttpClient client = new DefaultHttpClient();
				    	    	HttpGet req = new HttpGet(uri.toString());
								res = client.execute(req);
    	   } catch (ClientProtocolException e){
    		   Log.e(TAG, e.getMessage());
    		   return null;
    	   } catch (IOException e){
    		   Log.e(TAG, e.getMessage());
    		   return null;
    	   } catch (Exception e){
    		   Log.e(TAG, e.getMessage());
    		   return null;
    	   }
    	   int status = res.getStatusLine().getStatusCode();
    	   if (HttpStatus.SC_OK == status){
    		   try {
    			   ByteArrayOutputStream baop = new ByteArrayOutputStream();
    			   res.getEntity().writeTo(baop);
    			   return baop.toString();
    		   } catch (Exception e){
    			   Log.e(TAG, e.getMessage());
    			   return null;
    		   }
    	   } else {
    		   Log.d(TAG, "HTTP" + status);
    		   return null;
    	   }
       }    	
    }
    public void xmlBaker(String xml){
    	try{
    		XmlPullParser parser = Xml.newPullParser();
    		parser.setInput(new StringReader(xml));
    		int evt;
    		while ((evt = parser.next()) != XmlPullParser.END_DOCUMENT){
    			if (evt == XmlPullParser.START_TAG && "word".equals(parser.getName())){
    				arryadpt.add(parser.nextText());
    			} else if (evt == XmlPullParser.START_TAG && "related_keywords".equals(parser.getName())){
    				arryadpt.add(parser.nextText());
    			}
    		}
    	} catch (Exception e){
    		Log.e(TAG, e.getMessage());
    	}
    }
    public static String[] exInfo(String xml){
    	try {
    		String ret[] = new String[4];
    		XmlPullParser xparser = Xml.newPullParser();
    		xparser.setInput(new StringReader(xml));
    		int evt;
    		while ((evt = xparser.next()) != XmlPullParser.END_DOCUMENT){
    			if (evt == XmlPullParser.START_TAG && "entry_count".equals(xparser.getName())){
    				ret[0] = xparser.nextText();
    			}
    			if (evt == XmlPullParser.START_TAG && "followers_count".equals(xparser.getName())){
    				ret[1] = xparser.nextText();
    			}
    			if (evt == XmlPullParser.START_TAG && "title".equals(xparser.getName())){
    				ret[2] = xparser.nextText();
    			}
    			if (evt == XmlPullParser.START_TAG && "word".equals(xparser.getName())){
    				ret[3] = xparser.nextText();
    			}
    		}
    		return ret;
    	} catch (Exception e){
    		Log.e(TAG, e.getMessage());
    		return null;
    	}
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_kigo, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item){
    	switch (item.getItemId()){
    	case R.id.menu_settings:
    		Intent prefint = new Intent();
    		prefint.setClassName("org.pulpdust.kigo",
    				"org.pulpdust.kigo.KigoPrefs");
    		startActivityForResult(prefint, 2);
    		return true;
    	default:
    		return super.onOptionsItemSelected(item);
    	}
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data){
    	switch (requestCode){
    	case 2:
    		readPrefs();
    		if (obj != null){
        		arryadpt.clear();
          		xmlBaker(obj);
    		} else if (guri != null){
        		reLoad(guri);
    		} else {
    			goFind();
    		}
    		break;    	
    	}
    }
    public void readPrefs(){
    	SharedPreferences sprefs = PreferenceManager.getDefaultSharedPreferences(this);
    	tpbhvr = Integer.parseInt(sprefs.getString("tap_b", "0"));
    	fntsz = Integer.parseInt(sprefs.getString("font_size", "16"));
    	host = sprefs.getString("host", "http://h.hatena.ne.jp/");
    	send_to[0] = sprefs.getString("send_to", "");
    	cc[0] = sprefs.getString("cc", "");
    	bcc[0] = sprefs.getString("bcc", "");
    }
    public void loadSave(){
    	SharedPreferences spref = getSharedPreferences(svdt, 0);
    	sbj = spref.getString("sbj", "");
    	obj = spref.getString("obj", null);
    	guri = spref.getString("guri", null);
    }
    
    @Override
    public void onStop(){
    	super.onStop();
		SharedPreferences spref = getSharedPreferences(svdt, 0);
		SharedPreferences.Editor sedit = spref.edit();
		if (obj != null){
			sedit.putString("obj", obj);
		} else {
			sedit.putString("obj", null);
		}
    	if (!sbj.equals("")){
    		sedit.putString("sbj", sbj);
    	} else {
    		sedit.putString("sbj", "");
    	}
    	if (guri != null){
    		sedit.putString("guri", guri);
    	} else {
    		sedit.putString("guri", null);
    	}
		sedit.commit();
    }
}
