package org.pulpdust.unnetbrowser;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.view.Menu;
import android.view.MenuItem;

@TargetApi(11)
public class forHoneycomb {
	public static void setActionBar(Activity av, boolean hide){
		ActionBar ab = av.getActionBar();
		if (hide){
			ab.hide();
		} else {
			ab.show();
		}
	}
	public static void setActionBarBackground(Activity av, int resource){
		ActionBar ab = av.getActionBar();
		ab.setBackgroundDrawable(av.getResources().getDrawable(resource));
	}
	public static void showActionBar(Activity av){
		ActionBar ab = av.getActionBar();
		ab.show();
	}
	public static void hideActionBar(Activity av){
		ActionBar ab = av.getActionBar();
		ab.hide();
	}
	public static void setTitle(Activity av, CharSequence title, CharSequence subtitle){
		ActionBar ab = av.getActionBar();
		ab.setTitle(title);
		ab.setSubtitle(subtitle);
	}
	public static void prepareOptionsMenu(Menu m, int variation){
		MenuItem mip = (MenuItem) m.findItem(UnnetBrowserActivity.MENU_PRV);
		MenuItem min = (MenuItem) m.findItem(UnnetBrowserActivity.MENU_NXT);
		MenuItem mit = (MenuItem) m.findItem(UnnetBrowserActivity.MENU_TOP);
		MenuItem mib = (MenuItem) m.findItem(UnnetBrowserActivity.MENU_BTM);
		if (variation == 0){
			mip.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
			min.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
			mit.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
			mib.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
		} else if (variation == 1){
			mip.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
			min.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
			mit.setShowAsAction(MenuItem.SHOW_AS_ACTION_IF_ROOM);
			mib.setShowAsAction(MenuItem.SHOW_AS_ACTION_IF_ROOM);
		} else if (variation == 2){
			mip.setShowAsAction(MenuItem.SHOW_AS_ACTION_NEVER);
			min.setShowAsAction(MenuItem.SHOW_AS_ACTION_NEVER);
			mit.setShowAsAction(MenuItem.SHOW_AS_ACTION_NEVER);
			mib.setShowAsAction(MenuItem.SHOW_AS_ACTION_NEVER);
		}
	}
	public static void updateOptionsMenu(Activity av){
		av.invalidateOptionsMenu();
	}

}
