package org.pulpdust.kazaricon;

import java.util.ArrayList;
import java.util.List;

import android.os.Bundle;
import android.preference.PreferenceManager;
import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Spinner;

public class KazariconMainActivity extends Activity {
	Button dbutton;
	Button ubutton;
	NotificationManager nm;
	Spinner chooser;
	int selected = 0;
	int look;
	List<String> icons = new ArrayList<String>();
	ArrayAdapter<String> aicons;
	forBase fbs = new forBase();
	libKazari lkz = new libKazari();
	

    @Override
    public void onCreate(Bundle savedInstanceState) {
        readProps();
        if (look >= 1) {
        	setTheme(R.style.AppTheme_Dark);
        } else {
        	setTheme(R.style.AppTheme);
        }
        super.onCreate(savedInstanceState);
    	nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        setContentView(R.layout.kazaricon_main_activity);
        dbutton = (Button) findViewById(R.id.button1);
        dbutton.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				lkz.doDeco(getApplicationContext(), selected, nm);
			}
        });
        ubutton = (Button) findViewById(R.id.button2);
        ubutton.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View arg0) {
				unDeco();
			}
        });
        chooser = (Spinner) findViewById(R.id.spinner1);
        aicons = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, icons);
        aicons.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        chooser.setAdapter(aicons);
        aicons.add(getString(R.string.icon_droid));
        aicons.add(getString(R.string.icon_apple));
        aicons.add(getString(R.string.icon_window));
        aicons.add(getString(R.string.icon_dromini));
        aicons.add(getString(R.string.icon_betty));
        aicons.add(getString(R.string.icon_droopy));
        aicons.add(getString(R.string.icon_yamada));
        chooser.setSelection(selected);
        chooser.setOnItemSelectedListener(new Changer());
        showPreview();
    }
    public class Changer implements OnItemSelectedListener {
		@Override
		public void onItemSelected(AdapterView<?> av, View v, int pos,
				long id) {
			selected = pos;
			showPreview();
		}
		@Override
		public void onNothingSelected(AdapterView<?> av) {
			// TODO Auto-generated method stub
		}
    }
    public void showPreview(){
    	ImageView preview = (ImageView) findViewById(R.id.imageView1);
    	preview.setImageResource(lkz.whichIcon(selected));
    }
    public void unDeco(){
    	nm.cancel(1);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.kazaricon_main_activity, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem mi){
    	switch(mi.getItemId()){
    	case R.id.menu_settings:
    		Intent msi = new Intent();
    		msi.setClassName("org.pulpdust.kazaricon", "org.pulpdust.kazaricon.KazariconPreferences");
    		startActivity(msi);
    		return true;
    	default:
    		return super.onOptionsItemSelected(mi);
    	}
    }
    public void readProps(){
    	SharedPreferences props = getSharedPreferences(getString(R.string.app_code), MODE_PRIVATE);
    	selected = props.getInt("selected", 0);
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
		look = Integer.parseInt(sp.getString("look", "1"));
    }
    public void writeProps(){
    	SharedPreferences props = getSharedPreferences(getString(R.string.app_code), MODE_PRIVATE);
    	SharedPreferences.Editor pedit = props.edit();
    	pedit.putInt("selected", selected);
    	pedit.commit();
    }
    @Override
    protected void onStop(){
    	super.onStop();
    	writeProps();
    }
}
