package org.pulpdust.kazaricon;

import java.util.List;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.FragmentActivity;
import android.widget.Toast;

public class DaLauncherActivity extends FragmentActivity {
	final String DA_LAUNCH = "org.pulpdust.da.action.LAUNCH";
	final String DA_EX_TEXT = "org.pulpdust.da.extra.TEXT";
	final String DA_EX_THEME = "org.pulpdust.da.extra.THEME";
	final String DA_EX_RETURN = "org.pulpdust.da.extra.RETURN";
	final int DA_REQUEST = 0;
	int look;
	
	@Override
	public void onCreate(Bundle savedInstanceState){
		readPrefs();
		super.onCreate(savedInstanceState);
		if (!isIntentAvailable(this, DA_LAUNCH)) finish();
		Object flag = getLastCustomNonConfigurationInstance();
		if (flag != null){
			
		} else {
		String txt;
		if (Build.VERSION.SDK_INT >= 11){
			forHoneycomb fhc = new forHoneycomb();
			txt = fhc.getCopy(this).toString();
		} else {
			forBase fbs = new forBase();
			txt = fbs.getCopy(this).toString();
		}
		Intent dal = new Intent(DA_LAUNCH);
		dal.putExtra(DA_EX_TEXT, txt);
		dal.putExtra(DA_EX_THEME, look);
		startActivityForResult(Intent.createChooser(dal, getString(R.string.dalauncher)), DA_REQUEST);
		}
	}
	
	@Override
	protected void onActivityResult(int reqCode, int resCode, Intent data){
		switch(reqCode){
		case DA_REQUEST:
			if (resCode == RESULT_OK && data.getStringExtra(DA_EX_RETURN) != null){
				String rec = data.getStringExtra(DA_EX_RETURN);
				if (Build.VERSION.SDK_INT >= 11){
					forHoneycomb fhc = new forHoneycomb();
					fhc.doCopy(rec, this);
				} else {
					forBase fbs = new forBase();
					fbs.doCopy(data.getStringExtra(DA_EX_RETURN), this);
				}
				Toast.makeText(getApplicationContext(), getString(R.string.mes_toclip) + " " + rec, 
						Toast.LENGTH_SHORT).show();
			}
		}
		finish();
	}
	
	@Override
	public Object onRetainCustomNonConfigurationInstance(){
		boolean flag = true;
		return flag;
	}
	
	void readPrefs(){
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
		look = Integer.parseInt(sp.getString("look", "1"));
	}
	
    public boolean isIntentAvailable(Context cx, String at) {
        final PackageManager pm = cx.getPackageManager();
        final Intent intent = new Intent(at);
        List<ResolveInfo> list =
                pm.queryIntentActivities(intent,
                        PackageManager.MATCH_DEFAULT_ONLY);
        return list.size() > 0;
    }


}
