package org.pulpdust.kazaricon;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class BootedReceiver extends BroadcastReceiver {
	boolean startup;
	int selected;
	libKazari lkz = new libKazari();

	@Override
	public void onReceive(Context cx, Intent it) {
		readPrefs(cx);
		if (startup){
			NotificationManager nm = (NotificationManager) cx.getSystemService(Context.NOTIFICATION_SERVICE);
			lkz.doDeco(cx, selected, nm);
		}
	}
	
	void readPrefs(Context cx){
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(cx.getApplicationContext());
		startup = sp.getBoolean("startup", false);
		SharedPreferences ps = cx.getSharedPreferences(cx.getString(R.string.app_code), Context.MODE_PRIVATE);
		selected = ps.getInt("selected", 0);
	}

}
