package org.pulpdust.kazaricon;

import android.app.ActivityManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.widget.TextView;

public class AboutThisAndroidDa extends FragmentActivity {
	final static String DA_EX_TEXT = "org.pulpdust.da.extra.TEXT";
	final static String DA_EX_THEME = "org.pulpdust.da.extra.THEME";
	final static String DA_EX_RETURN = "org.pulpdust.da.extra.RETURN";
	TextView sys;
	TextView ver;
	TextView mem;
	TextView avl;
	TextView cpu;
	
	@Override
	public void onCreate(Bundle savedInstanceState){
		int cs = getIntent().getIntExtra(DA_EX_THEME, 0);
		if (cs >= 1){
			setTheme(R.style.AppTheme_Dialog_Dark);
		} else {
			setTheme(R.style.AppTheme_Dialog);
		}
		super.onCreate(savedInstanceState);
		setContentView(R.layout.kazaricon_system_info);
		sys = (TextView) findViewById(R.id.textView1);
		ver = (TextView) findViewById(R.id.textView2);
		mem = (TextView) findViewById(R.id.textView4);
		avl = (TextView) findViewById(R.id.textView8);
		cpu = (TextView) findViewById(R.id.textView6);
		ActivityManager am = (ActivityManager) getSystemService(ACTIVITY_SERVICE);
		ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
		am.getMemoryInfo(mi);
		String space = "";
		if (mi.lowMemory){
			space = getString(R.string.low);
		} else {
			space = getString(R.string.enough);
		}
		sys.setText(Build.BRAND + " " + Build.MODEL);
		ver.setText(getString(R.string.version) + " " + Build.VERSION.RELEASE + 
				" (" + Build.VERSION.INCREMENTAL + ")");
		if (Build.VERSION.SDK_INT >= 16){
			forJerrybean fjb = new forJerrybean();
			mem.setText(bRound(fjb.totalMem(mi)));
			avl.setText(bRound(mi.availMem) + " (" + space + ")");
		} else {
			mem.setText(space);
			avl.setText(bRound(mi.availMem));
		}
		cpu.setText(Build.CPU_ABI);
	}
	
	String bRound(long n){
		String ret;
		String u;
		float f = n;
		u = "B";
		if (f >= 1024.0) {f = f/1024; u = "KB";}
		if (f >= 1024.0) {f = f/1024; u = "MB";}
		if (f >= 1024.0) {f = f/1024; u = "GB";}
		ret = String.format("%.1f", f) + u;
		return ret;
	}

}
